% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_cross2.R
\name{read_cross2}
\alias{read_cross2}
\title{Read QTL data from files}
\usage{
read_cross2(file, quiet = TRUE)
}
\arguments{
\item{file}{Character string with path to the
\href{https://yaml.org}{YAML} or \href{https://json.org}{JSON} file containing all of the control
information. This could instead be a zip file containing all of the
data files, in which case the contents are unzipped to a temporary
directory and then read.}

\item{quiet}{If \code{FALSE}, print progress messages.}
}
\value{
Object of class \code{"cross2"}. For details, see the
\href{https://kbroman.org/qtl2/assets/vignettes/developer_guide.html}{R/qtl2 developer guide}.
}
\description{
Read QTL data from a set of files
}
\details{
A control file in \href{https://yaml.org}{YAML} or
\href{https://json.org}{JSON} format contains information
about basic parameters as well as the names of the series of
data files to be read. See the
\href{https://kbroman.org/qtl2/pages/sampledata.html}{sample data files} and the
\href{https://kbroman.org/qtl2/assets/vignettes/input_files.html}{vignette describing the input file format}.
}
\examples{
\dontrun{
yaml_file <- "https://kbroman.org/qtl2/assets/sampledata/grav2/grav2.yaml"
grav2 <- read_cross2(yaml_file)
}
zip_file <- system.file("extdata", "grav2.zip", package="qtl2")
grav2 <- read_cross2(zip_file)
}
\seealso{
\code{\link[=read_pheno]{read_pheno()}}, \code{\link[=write_control_file]{write_control_file()}},
sample data files at \url{https://kbroman.org/qtl2/pages/sampledata.html}
and \url{https://github.com/rqtl/qtl2data}
}
\keyword{IO}
