% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbind_viterbi.R
\name{cbind.viterbi}
\alias{cbind.viterbi}
\title{Join viterbi results for different chromosomes}
\usage{
\method{cbind}{viterbi}(...)
}
\arguments{
\item{...}{Imputed genotype objects as produced by
\code{\link[=viterbi]{viterbi()}}. Must have the same set of individuals.}
}
\value{
An object of class \code{"viterbi"}, like the input; see \code{\link[=viterbi]{viterbi()}}.
}
\description{
Join multiple viterbi objects, as produced by \code{\link[=viterbi]{viterbi()}}, for the
same set of individuals but different chromosomes.
}
\examples{
grav2 <- read_cross2(system.file("extdata", "grav2.zip", package="qtl2"))
map <- insert_pseudomarkers(grav2$gmap, step=1)
gA <- viterbi(grav2[1:5,1:2], map, error_prob=0.002)
gB <- viterbi(grav2[1:5,3:4], map, error_prob=0.002)
g <- cbind(gA, gB)

}
\seealso{
\code{\link[=rbind.viterbi]{rbind.viterbi()}}, \code{\link[=viterbi]{viterbi()}}
}
