% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show.R
\name{showQsprayOption<-}
\alias{showQsprayOption<-}
\title{Set a show option to a 'qspray' object}
\usage{
showQsprayOption(x, which) <- value
}
\arguments{
\item{x}{a \code{qspray} object}

\item{which}{which option to set; this can be \code{"x"}, 
\code{"showMonomial"}, or \code{"showQspray"}}

\item{value}{the value of the option}
}
\value{
This returns the updated \code{qspray}.
}
\description{
Set a show option to a \code{qspray} object
}
\note{
The interest of setting some show options to a 'qspray' is that these 
  options are preserved by some operations. See the examples and the README.
}
\examples{
set.seed(3141)
( qspray <- rQspray() )
showQsprayOption(qspray, "x") <- "a"
qspray
# this is identical to:
showQsprayOption(qspray, "showMonomial") <- showMonomialX1X2X3("a")
# and also identical to:
showQsprayOption(qspray, "showQspray") <- showQsprayX1X2X3("a")
# old show method:
showQsprayOption(qspray, "showMonomial") <- showMonomialOld()
qspray
# show options are preserved by some operations:
qspray^2
3*qspray
derivQspray(qspray, 1)
swapVariables(qspray, 1, 2)
substituteQspray(qspray, c(NA, NA, "3/2"))
# for the binary arithmetic operations, the show options of the first 
# operand are transferred to the result when possible:
( qspray2 <- rQspray() )
qspray + qspray2 
}
