% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groebner.R
\name{groebner}
\alias{groebner}
\title{Gröbner basis}
\usage{
groebner(G, minimal = TRUE, reduced = TRUE)
}
\arguments{
\item{G}{a list of qspray polynomials, the generators of the ideal}

\item{minimal}{Boolean, whether to return a minimal basis}

\item{reduced}{Boolean, whether to return the reduced basis}
}
\value{
A Gröbner basis of the ideal generated by \code{G}, given as a list 
  of qspray polynomials.
}
\description{
Returns a Gröbner basis following Buchberger's algorithm 
  using the lexicographical order.
}
\examples{
library(qspray)
f <- qsprayMaker(string = "x^(3) - 2 x^(1,1)")
g <- qsprayMaker(string = "x^(2,1) - 2 x^(0,2) + x^(1)")
groebner(list(f, g), FALSE, FALSE)
# other example
\donttest{x <- qlone(1); y <- qlone(2); z <- qlone(3)
f1 <- x^2 + y + z^2 - 1
f2 <- x^2 + y + z - 1
f3 <- x + y^2 + z - 1
gb <- groebner(list(f1, f2, f3))
lapply(gb, prettyQspray, vars = c("x", "y", "z"))}
}
\references{
Cox, Little & O'Shea. 
\emph{Ideals, Varieties, and Algorithms. 
An Introduction to Computational Algebraic Geometry and Commutative Algebra.}
Fourth edition, Springer 2015.
}
