% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation.R
\name{blosc_unshuffle_raw}
\alias{blosc_unshuffle_raw}
\title{Un-shuffle a raw vector}
\usage{
blosc_unshuffle_raw(data, bytesofsize)
}
\arguments{
\item{data}{A raw vector to be unshuffled.}

\item{bytesofsize}{Either \code{4} or \code{8}.}
}
\value{
The unshuffled vector.
}
\description{
Un-shuffles a raw vector using BLOSC un-shuffle routines.
}
\examples{
x <- serialize(1L:1000L, NULL)
xshuf <- blosc_shuffle_raw(x, 4)
xunshuf <- blosc_unshuffle_raw(xshuf, 4)
}
