% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simQLData.R
\name{setQLdata}
\alias{setQLdata}
\title{Set quasi-likelihood (QL) data}
\usage{
setQLdata(runs, X = NULL, chol = TRUE, na.rm = TRUE, verbose = FALSE)
}
\arguments{
\item{runs}{list or matrix of simulation results from \code{\link{simQLdata}}}

\item{X}{list or matrix of model parameters}

\item{chol}{logical, \code{TRUE} (default), whether to decompose variance matrices}

\item{na.rm}{if \code{TRUE} (default), remove `NA` values from simulation results}

\item{verbose}{if \code{TRUE}, print intermediate output}
}
\value{
An object of class \code{QLdata}  as a data frame with columns:
  \item{X}{ Model parameters (\code{n=1},...,\code{q}) }
  \item{mean}{ Results of simulations (\code{m=1},...,\code{p}) }
  \item{var}{ Simulation variances of statistics (\code{m=1},...,\code{p}) }
  \item{L}{ if applicable, Cholesky decomposed terms of variance matrices of statistics (k=1,...,(m*(m+1)/2))}
	where `\code{p}` denotes the number of user defined statistics and `\code{q}` the problem dimension, that is,
 the number of parameters to be estimated.	

	The following items are stored as attributes:

  \item{chol}{ see above}
	 \item{nsim}{ number of simulations at each point }
	 \item{xdim}{ parameter dimension}
	 \item{nWarnings}{ Number of warnings during simulations}
 \item{nErrors}{ Number of errors during simulations}
	 \item{nIgnored}{ List of parameters ignored (because of failures)}
}
\description{
Aggregate the data for quasi-likelihood estimation
}
\details{
The function aggregates all neccessary data for quasi-likelihood estimation storing the
	sample locations and the corresponding simulation results of the statistics.
 If `\code{X}` equals \code{NULL}, then the sample points are taken from the object `\code{runs}`.

 The most critical part is the decomposition of variance matrices for each sample location if `\code{chol}`
 equals \code{TRUE}. The decompositions are used for average approximations of the variance matrix of statistics.
 If these fail for any reason we try to ignore, if possible, the corresponding sample point, exclude
 it from all following calculations with some information for the user. Unless the user preferes to supply a constant
 estimate of the variance matrix for estimation later by function \code{\link{qle}}, the default is to approximate the variance
 at any parameter by either a kriging interpolation of the \emph{Cholesky} terms or as an average over all sampled variance
 matrices using the decomposed Cholesky terms.
}
\examples{
# simulate model statistics at LHS design
sim <- simQLdata(sim =
         function(x,cond) {
           X <- rlnorm(cond$n,x[1],x[2])
           c("MED"=median(X),"MAD"=mad(X))
         },
         cond=list("n"=10),
         nsim=10, N=10, method="maximinLHS",
         lb=c("mu"=-1.5,"sd"=0), ub=c("mu"=2,"sd"=1))

# setup QL approximation mode
qldata <- setQLdata(sim,chol=TRUE,verbose=TRUE) 
  
}
\author{
M. Baaske
}
