% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic_functions.R
\docType{methods}
\name{check}
\alias{check}
\title{Generic checking function}
\usage{
check(obj, ...)
}
\arguments{
\item{obj}{the object to be checked.}

\item{...}{extra arguments, mainly used by graphic functions.}
}
\value{
Reports the results of convergence tests and/or produces diagnostic plots.
}
\description{
Generic function for checking R objects which produces, for instance, convergence tests or diagnostic plots. 
             For \code{qgam} objects \code{check.qgam()} will be used.
}
\examples{
#######
# Using check.qgam
#######
library(qgam)
set.seed(0)
dat <- gamSim(1, n=200)
b<-qgam(y~s(x0)+s(x1)+s(x2)+s(x3), data=dat, qu = 0.5, 
        control = list("tol" = 0.01)) # <- semi-sloppy tolerance to speed-up calibration
plot(b, pages=1)
check(b, pch=19, cex=.3) 
}
\author{
Matteo Fasiolo <matteo.fasiolo@gmail.com>.
}
