% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfa2.1.R
\name{sqdft}
\alias{sqdft}
\title{Spline Quantile Discrete Fourier Transform (SQDFT)}
\usage{
sqdft(y, tau, c0 = 0.02, d = 4, weighted = FALSE, n.cores = 1, cl = NULL)
}
\arguments{
\item{y}{vector or matrix of time series (if matrix, \code{nrow(y)} = length of time series)}

\item{tau}{sequence of quantile levels in (0,1)}

\item{c0}{penalty parameter}

\item{d}{subsampling rate of quantile levels (default = 1)}

\item{weighted}{if \code{TRUE}, penalty function is weighted (default = \code{FALSE})}

\item{n.cores}{number of cores for parallel computing (default = 1)}

\item{cl}{pre-existing cluster for repeated parallel computing (default = \code{NULL})}
}
\value{
matrix or array of the spline quantile discrete Fourier transform of \code{y}
}
\description{
This function computes spline quantile discrete Fourier transform (SQDFT) for univariate or multivariate time series
through trigonometric spline quantile regression.
}
\examples{
y <- stats::arima.sim(list(order=c(1,0,0), ar=0.5), n=64)
tau <- seq(0.1,0.9,0.05)
y.sqdft <- sqdft(y,tau,c0=0.02,d=4)
n <- length(y)
ff <- c(0:(n-1))/n
sel.f <- which(ff > 0 & ff < 0.5)
y.qacf <- qdft2qacf(y.sqdft)
y.qper.sqrlw <- qspec.lw(y.qacf,M=5)$spec
qfa.plot(ff[sel.f],tau,Re(y.qper.sqrlw[sel.f,]))
}
