\name{cm_code.combine}
\alias{cm_code.combine}
\title{Combine Codes}
\usage{
  cm_code.combine(x2long.obj, combine.code.list,
    rm.var = NULL)
}
\arguments{
  \item{x2long.obj}{An object from
  \code{\link[qdap]{cm_range2long}},
  \code{\link[qdap]{cm_time2long}} or
  \code{\link[qdap]{cm_df2long}}.}

  \item{combine.code.list}{A list of named character
  vectors of at least two code column names to combine}

  \item{rm.var}{Name of the repeated measures column.}
}
\value{
  Returns a dataframe with combined occurrences of supplied
  overlapping codes added.
}
\description{
  Combine all occurrences of codes into a new code.
}
\note{
  The code column must be named \code{"code"} and your
  start and end columns must be named \code{"start"} and
  \code{"end"}.
}
\examples{
\dontrun{
foo <- list(
    AA = qcv(terms="1:10"),
    BB = qcv(terms="1:2, 3:10, 19"),
    CC = qcv(terms="1:3, 5:6")
)

foo2  <- list(
    AA = qcv(terms="4:8"),
    BB = qcv(terms="1:4, 10:12"),
    CC = qcv(terms="1, 11, 15:20"),
    DD = qcv(terms="")
)

(x <- cm_range2long(foo))
(z <- cm_range2long(foo, foo2, v.name="time"))
cm_code.combine(x, list(AB=qcv(AA, BB)))
cm_code.combine(x, list(ALL=qcv(AA, BB, CC)))
combines <- list(AB=qcv(AA, BB), ABC=qcv(AA, BB, CC))
cm_code.combine(z, combines, rm.var = "time")

#WITH cm_time2long
x <- list(
    transcript_time_span = qcv(00:00 - 1:12:00),
    A = qcv(terms = "2.40:3.00, 5.01, 6.02:7.00, 9.00"),
    B = qcv(terms = "2.40, 3.01:3.02, 5.01, 6.02:7.00, 9.00,
        1.12.00:1.19.01"),
    C = qcv(terms = "2.40:3.00, 5.01, 6.02:7.00, 9.00, 17.01")
)

y <- list(
    transcript_time_span = qcv(00:00 - 1:12:00),
    A = qcv(terms = "2.40:3.00, 5.01, 6.02:7.00, 9.00"),
    B = qcv(terms = "2.40, 3.01:3.02, 5.01, 6.02:7.00, 9.00,
        1.12.00:1.19.01"),
    C = qcv(terms = "2.40:3.00, 5.01, 6.02:7.00, 9.00, 17.01")
)

dat <- cm_time2long(x, y)
head(dat, 12)
cm_code.combine(dat, list(P=qcv(A, B), Q=qcv(B, C), R=qcv(A, B, C)), "variable")
}
}
\seealso{
  \code{\link[qdap]{cm_range2long}},
  \code{\link[qdap]{cm_time2long}},
  \code{\link[qdap]{cm_df2long}},
  \code{\link[qdap]{cm_code.blank}},
  \code{\link[qdap]{cm_code.exclude}},
  \code{\link[qdap]{cm_code.overlap}},
  \code{\link[qdap]{cm_code.transform}}
}
\keyword{co-occurrence}

