% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07_thresholds.R
\name{thresholds}
\alias{thresholds}
\title{Admisibles quantile thresholds}
\usage{
thresholds(x, ...)
}
\arguments{
\item{x}{is a data frame that contains the manifest variables used to
estimate the qcpm models}

\item{\dots}{Further arguments passed on to \code{thresholds}.}
}
\value{
A vector containing the maximum and minimum admisible quantile threshold values.
}
\description{
\code{thresholds} provides the maximum and minimum admisible quantile threshold.
}
\details{
The argument \code{x} is data frame that contains the manifest variables used to
estimate the qcpm models
}
\examples{

# Example of QC-PM in Well-Being analysis
# model with three LVs and reflective indicators

# load library and dataset province
library(qcpm)
data(province)

thresholds(province)


}
\references{
Davino, C., Dolce, P., Taralli, S., Vistocco, D. (2020)  Composite-Based Path 
Modeling for Conditional Quantiles Prediction. An Application to Assess 
Health Differences at Local Level in a Well-Being Perspective. 
\emph{Social Indicator Research}, pp. 1-30, doi:10.1007/s11205-020-02425-5.

Davino, C., Vinzi, V.E. (2016) Quantile composite-based path
modeling. \emph{Advansed Data Analysis and Classification}, \bold{10}, pp. 
491–520, doi:10.1007/s11634-015-0231-9.

Dolce, P., Davino, C., Vistocco, D. (2021) Quantile composite-based path modeling: 
algorithms, properties and applications.\emph{Advansed Data Analysis and Classification},
doi:10.1007/s11634-021-00469-0.
}
\author{
Cristina Davino, Pasquale Dolce, Giuseppe Lamberti, Domenico Vistocco
}
