% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qb_reports.R
\name{get_report}
\alias{get_report}
\title{Get a report}
\usage{
get_report(subdomain, auth, table_id, report_id, agent = NULL)
}
\arguments{
\item{subdomain}{Character vector with one element. Found at the beginning of
the Quickbase URL. Realm specific.}

\item{auth}{Character vector with one element. The Quickbase authentication
scheme you are using to authenticate the request (e.g., user token).}

\item{table_id}{Character vector with one element. Found in the URL of a
Quickbase table.}

\item{report_id}{Character vector with one element. Found in the 'Reports &
Charts' page in Quickbase and in the report URL.}

\item{agent}{Optional. Character vector with one element. Describes
user/agent making API call.}
}
\value{
A named list.
}
\description{
Get metadata about a report.
}
\examples{
\dontrun{
   get_report(subdomain = "abc",
              auth = keyring::key_get("qb_example"),
              table_id = "bn9d8iesz",
              report_id = "7")
}
}
