% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emp_c_copula.R
\name{emp_c_copula}
\alias{emp_c_copula}
\alias{emp_c_copula_eval}
\title{The empirical checkerboard copula}
\usage{
emp_c_copula(X, smoothing = TRUE, resolution)

emp_c_copula_eval(X, u, smoothing = TRUE, resolution)
}
\arguments{
\item{X}{a data frame with two columns containing the observations of the sample. Each row contains
one observation.}

\item{smoothing}{a logial indicating whether the checkerboard aggregation is computed (default = TRUE).}

\item{resolution}{an integer indicating the resolution of the checkerboard aggregation, i.e.
the number of vertical/horizontal strips of the checkerboard copula.}

\item{u}{a data.frame with two columns containing the evaluation points. Each row consists of a x and y value.}
}
\value{
\code{emp_c_copula()} returns a matrix with the mass distribution of the empirical
(checkerboard) copula.

\code{emp_c_copula_eval()} returns a vector of evaluations of the empirical
(checkerboard) copula.
}
\description{
The function \code{emp_c_copula()} computes the mass distribution of the
empirical (checkerboard) copula, given a bivariate sample. \code{emp_c_copula_eval()} evaluates the
the empirical (checkerboard) copula at given points.
If \code{smoothing} = FALSE, the empirical copula is computed (if there are ties in the sample an adjusted empirical copula is computed),
otherwise the empirical checkerboard copula - a smoothed version of the empirical copula - is computed. For more information of the calculations, see details.
}
\details{
If the observations come from a distribution with continuous margins,
i.e. there are no ties in the sample, the function \code{emp_c_copula()} gives the same result
as the function \code{C.n()} in the \code{copula} package.
If there are ties in the sample, the empirical copula is adjusted and calculated in the following way: \cr
Let (u_i,v_i) := (F_n(x_i),G_n(y_i)) be the pseudo-observations for i in \{1,\ldots,n\} and (u_1',v_1'),\ldots, (u_m',v_m') the distinct pairs of pseudo-observations with m leq n. Moreover set S_1:=\{0, u_1, \ldots, u_{m_1}\} and S_2:=\{0, v_1,\ldots, v_{m_2}\} and define the quantities t_i,r_i and s_i for i=1,\ldots, m by
\deqn{t_i := sum_{j=1}^n 1_{(u_i',v_i')}(u_j,v_j)}
\deqn{r_i := sum_{j=1}^n 1_{u_i}(u_j)}
\deqn{s_i := sum_{j=1}^n 1_{v_i}(v_j)}
where 1 defines the indicator function.
Define the empirical subcopula A'_n: S_1 x S_2 to \{0,1/n, \ldots, (n-1)/n,1\} by
\deqn{A'_n(s_1,s_2)= 1/n  sum_{i=1}^m t_i * 1_{[0,s_1] x [0,s_2]} (u_i', v_i')=1/n sum_{i=1}^n 1_{[0,s_1] x [0,s_2]} (u_i, v_i)}
for all s_1 in S_1 and s_2 in S_2. \cr
We extend the subcopula A'_n to a copula by defining the transformations w_i:[0,1]^2 to [u_i'-r_i/n,u_i'] x [v_i'-s_i/n,v_i'] by
\deqn{w_i(x,y)=(u_i'-r_i/n+r_i*x/n, v_i'-s_i/n + s_iy/n)}
and set the measure of the empirical copula mu_{A_n}^B := 1/n sum_{i=1}^m t_i mu_B^{w_i}, where B denotes the product copula.

The checkerboard aggregation is computed as usual (see references).
}
\note{
The calculation of the empirical copula with a high sample size (and resolution rate) can take time.
}
\references{
Deheuvels, P. (1979). La fonction de dependance empirique et ses proprietas: un test non parametrique d'independance, Acad. Roy. Belg. Bull. Cl. Sci., 5th Ser. 65, 274-292.

Li, X., Mikusinski, P. and Taylor, M.D. (1998). Strong approximation of copulas, Journal of Mathematical Analysis and Applications, 255, 608-623.

Genest, C., Neshlehova J.G. and Remillard, B. (2014). On the empirical multilinear copula process for count data. Bernoulli, 20 (3), 1344-1371.
}
