% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pystr_rsplit.R
\name{pystr_rsplit}
\alias{pystr_rsplit}
\title{Right split a string.}
\usage{
pystr_rsplit(str, sep = " ", maxsplit = nchar(str) - 1)
}
\arguments{
\item{str}{A string.}

\item{sep}{A string.}

\item{maxsplit}{An integer.}
}
\value{
A character vector.
}
\description{
Return a character vector of the words in the string, using \code{sep} as the delimiter
string.
}
\details{
If \code{maxsplit} is given, at most \code{maxsplit} splits are done, the rightmost
ones. If \code{sep} is not specified, any whitespace string is a separator.
Except for splitting from the right, \code{pystr_rsplit} behaves like
\code{\link{pystr_split}}.
}
\examples{
pystr_rsplit("a--b--c", "--")
pystr_rsplit("a--b--c", "--", 1)
}
\references{
\url{https://docs.python.org/3/library/stdtypes.html#str.rsplit}
}
\seealso{
\code{\link{pystr_split}}
}

