% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RevokeQualification.R
\name{RevokeQualification}
\alias{RevokeQualification}
\alias{RevokeQualifications}
\alias{revokequal}
\alias{DisassociateQualificationFromWorker}
\title{Revoke a Qualification from a Worker}
\usage{
RevokeQualification(
  qual,
  workers,
  reasons = NULL,
  verbose = getOption("pyMTurkR.verbose", TRUE)
)
}
\arguments{
\item{qual}{A character string containing a QualificationTypeId.}

\item{workers}{A character string containing a WorkerId, or a vector of
character strings containing multiple WorkerIds.}

\item{reasons}{An optional character string, or vector of character strings
of length equal to length of the \code{workers} parameter, supplying each
worker with a reason for revoking their Qualification. Workers will see this
message.}

\item{verbose}{Optionally print the results of the API request to the
standard output. Default is taken from \code{getOption('pyMTurkR.verbose',
TRUE)}.}
}
\value{
A data frame containing the QualificationTypeId, WorkerId, reason
(if applicable), and whether each request was valid.
}
\description{
Revoke a Qualification from a worker or multiple workers. This deletes their
qualification score and any record thereof.
}
\details{
A simple function to revoke a Qualification assigned to one or more workers.

\code{RevokeQualifications()}, \code{revokequal()} and
\code{DisassociateQualificationFromWorker()} are aliases.
}
\examples{

\dontrun{
qual1 <-
AssignQualification(workers = "A1RO9UJNWXMU65",
                    name = "Worked for me before",
                    description = "This qualification is for people who have worked for me before",
                    status = "Active",
                    keywords = "Worked for me before")

RevokeQualification(qual = qual1$QualificationTypeId,
                    worker = qual1$WorkerId,
                    reason = "No longer needed")

DisposeQualificationType(qual1$QualificationTypeId)

}

}
\references{
\href{https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DisassociateQualificationFromWorkerOperation.html}{API Reference}
}
\seealso{
\code{\link{GrantQualification}}

\code{\link{RejectQualification}}
}
\author{
Tyler Burleigh, Thomas J. Leeper
}
\keyword{Qualifications}
