% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pxweb_get.R
\name{pxweb_get_data}
\alias{pxweb_get_data}
\title{Do a GET call to PXWEB API and return a data.frame}
\usage{
pxweb_get_data(
  url,
  query,
  verbose = TRUE,
  column.name.type = "text",
  variable.value.type = "text"
)
}
\arguments{
\item{url}{a \code{pxweb} object or url that can be coherced to a \code{pxweb} object.}

\item{query}{a json string, json file or list object that can be coherced to a \code{pxweb_query} object.}

\item{verbose}{should large queries print out progress.}

\item{column.name.type}{character: should \code{code} or \code{text} be used as column names?}

\item{variable.value.type}{character: should \code{code} or \code{text} be used as values in columns?}
}
\description{
Do a GET call to PXWEB API and return a data.frame
}
\details{
The functions use will do a \code{pxweb_query} to a PXWEB \code{url} and return a \code{data.frame}.
This is a wrapper for the \code{pxweb_get} function.
}
\examples{
\dontrun{
url <- "http://api.scb.se/OV0104/v1/doris/sv/ssd/BE/BE0101/BE0101A/BefolkningNy"
query <- file.path(system.file(package = "pxweb"), 
                   "extdata", "examples", "json_query_example.json")
df <- pxweb_get_data(url = url, query = query)
}

}
\seealso{
See \code{\link{pxweb_get}} for mor general usage and \code{\link{pxweb_query}} for details on PXWEB queries.
}
