% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style_apa.R
\name{style.apa.chisq}
\alias{style.apa.chisq}
\title{Formats a Pearson's Chi-squared Test for Count Data}
\usage{
style.apa.chisq(x, print.n = TRUE, n.name = "N")
}
\arguments{
\item{x}{a list. First item must be a chi-squared test (htest class) from
\code{\link[stats]{chisq.test}}. All other list items will be ignored.}

\item{print.n}{a logical, indicating whether number of participants is
printed.}

\item{n.name}{a character, giving the name or letter for the number of
participants}
}
\value{
character vector with a formatted character vector.
}
\description{
This style functions takes a chi-squared test (htest class) from
\code{\link[stats]{chisq.test}} and transforms it into a formatted
character vector. Statistics are printed optionally (not by default).
}
\details{
Please note that this is a internal style function. It is called
from \code{\link{pprint}} and not exported to user namespace. Usually
\code{\link{pprint}} determines the correct style function automatically,
but you can define the style function by using the \code{format} argument
of \code{\link{pprint}} (pass the name of this function without
\code{style.apa.} prefix). Additionally you can pass the arguments listed
in this documentation to \code{\link{pprint}}.

Argument \code{x} of this function expects a list. Be aware that you do not
have to pass a list to \code{\link{pprint}} or \code{\link{pull.pubprint}}
-- these functions will convert your arguments. This is only necessary if
you want to pass additionally information to the internal style functions
(see vignette for examples).
}
\examples{
x <- matrix(c(141,29,43,26,5,10,26,12,10), nc=3)

pprint(chisq.test(x), format = "chisq")
pprint(chisq.test(x), format = "chisq", n.name = "n")
pprint(chisq.test(x), format = "chisq", print.n = FALSE)
}
\seealso{
\code{\link[stats]{chisq.test}}

Other APA.style.functions: \code{\link{style.apa.anova}},
  \code{\link{style.apa.bartlett}},
  \code{\link{style.apa.character}},
  \code{\link{style.apa.cor.test}},
  \code{\link{style.apa.df}},
  \code{\link{style.apa.fisher}},
  \code{\link{style.apa.ks}},
  \code{\link{style.apa.numeric}},
  \code{\link{style.apa.p.value}},
  \code{\link{style.apa.shapiro}},
  \code{\link{style.apa.summary.aovlist}},
  \code{\link{style.apa.summary.lm.beta.coeff}},
  \code{\link{style.apa.summary.lm.coeff}},
  \code{\link{style.apa.summary.lm.equation}},
  \code{\link{style.apa.summary.lm.model}},
  \code{\link{style.apa.t.test}}
}

