% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densities-mpsnorm.R
\name{mpsnorm}
\alias{mpsnorm}
\alias{dmpsnorm}
\alias{pmpsnorm}
\alias{rmpsnorm}
\title{Marginal Publication Selection Meta-analysis Model}
\usage{
dmpsnorm(x, theta0, tau, sigma, alpha = c(0, 0.025, 0.05, 1), eta, log = FALSE)

pmpsnorm(
  q,
  theta0,
  tau,
  sigma,
  alpha = c(0, 0.025, 0.05, 1),
  eta,
  lower.tail = TRUE,
  log.p = FALSE
)

rmpsnorm(n, theta0, tau, sigma, alpha = c(0, 0.025, 0.05, 1), eta)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{theta0}{vector of means.}

\item{tau}{vector of heterogeneity parameters.}

\item{sigma}{vector of study standard deviations.}

\item{alpha}{vector of thresholds for publication bias.}

\item{eta}{vector of publication probabilities, normalized to sum to 1.}

\item{log, log.p}{logical; If \code{TRUE}, probabilities are given as
\code{log(p)}.}

\item{lower.tail}{logical; If \code{TRUE} (default), the probabilities are
\eqn{P[X\leq x]} otherwise, \eqn{P[X\geq x]}.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken
to be the number required.}
}
\value{
\code{dmpsnorm} gives the density, \code{pmpsnorm} gives the distribution
function, and \code{rmpsnorm} generates random deviates.
}
\description{
Density, distribution, and random variate generation for the marginalized
distribution of the publication selection meta-analysis model
}
\details{
These functions assume a normal underlying effect size distribution and
one-sided selection on the effects. For the fixed effects publication
bias model see \code{\link{psnorm}}.
}
\examples{
rmpsnorm(100, theta0 = 0, tau = 0.1, sigma = 0.1, eta = c(1, 0.5, 0.1))
}
\references{
Hedges, Larry V. "Modeling publication selection effects
in meta-analysis." Statistical Science (1992): 246-255.

Moss, Jonas and De Bin, Riccardo. "Modelling publication
bias and p-hacking" Forthcoming (2019)
}
