% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ma.R
\name{ma}
\alias{ma}
\alias{psma}
\alias{phma}
\alias{cma}
\alias{allma}
\title{Meta-analysis Correcting for Publication Bias or p-hacking}
\usage{
ma(
  yi,
  vi,
  bias = c("publication selection", "p-hacking", "none"),
  data,
  alpha = c(0, 0.025, 0.05, 1),
  prior = NULL,
  ...
)

psma(yi, vi, data, alpha = c(0, 0.025, 0.05, 1), prior = NULL, ...)

phma(yi, vi, data, alpha = c(0, 0.025, 0.05, 1), prior = NULL, ...)

cma(yi, vi, data, prior = NULL, ...)

allma(yi, vi, data, alpha = c(0, 0.025, 0.05, 1), prior = NULL, ...)
}
\arguments{
\item{yi}{Numeric vector of length code{k} with observed effect size
estimates.}

\item{vi}{Numeric vector of length code{k} with sampling variances.}

\item{bias}{String; If "publication bias", corrects for publication bias. If
"p-hacking", corrects for p-hacking.}

\item{data}{Optional list or data frame containing \code{yi} and \code{vi}.}

\item{alpha}{Numeric vector; Specifies the cutoffs for significance.
Should include 0 and 1. Defaults to (0, 0.025, 0.05, 1).}

\item{prior}{Optional list of prior parameters. See the details.}

\item{...}{Passed to \code{rstan::sampling}.}
}
\value{
An S4 object of class \code{mafit} when \code{ma}, \code{psma}, \code{phma} or \code{cma} is
run. A list of \code{mafit} objects when \code{allma} is run.
}
\description{
Bayesian random effects meta-analysis. Correct for publication bias,
correct for p-hacking, or run an ordinary meta-analysis without any
correction.
}
\details{
\code{ma} does a Bayesian meta-analysis with the type of correction used specified
by \code{bias}. \code{psma} is a wrapper for \code{ma} with
\code{bias = "publication selection"}, \code{phma} is a wrapper with
\code{bias = "p-hacking"}, while \code{cma} has \code{bias = "none"}. The function
\code{allma} runs all \code{bias} options and returns a list.

The \code{bias} options are:
\enumerate{
\item \verb{publication selection}: The model of publication bias described in
Hedges (1992).
\item \code{p-hacking}: The model for \emph{p}-hacking described in Moss & De Bin (2019).
\item \code{none}: Classical random effects meta-analysis with no correction for
selection bias.
}

The effect size distribution is normal with mean \code{theta0} and standard
deviation \code{tau}. The prior for \code{theta0} is normal with
parameters \code{theta0_mean} (default: 0), \code{theta0_sd} (default: 1).
The prior for \code{tau} is half normal with parameters \code{tau_mean}
(default: 1), \code{tau_sd} (default: 1). \code{eta} is the vector of
\code{K} normalized publication probabilities (publication bias model) or
\code{K} \emph{p}-hacking probabilities (\emph{p}-hacking model). The prior of eta
is Dirchlet with parameter eta0, which defaults to \code{rep(1, K)}
for the publication bias model and the p-hacking model. \code{eta0} is the
prior for the Dirichlet distribution over the non-normalized etas in the
publication bias model, and they are forced to be decreasing.
To change the prior parameters, pass them to \code{prior} in a list.
}
\examples{
\donttest{
phma_model <- phma(yi, vi, data = metafor::dat.begg1989)
}
prior <- list(
  eta0 = c(3, 2, 1),
  theta0_mean = 0.5,
  theta0_sd = 10,
  tau_mean = 1,
  tau_sd = 1
)
\donttest{
psma_model <- psma(yi, vi, data = metafor::dat.begg1989, prior = prior)
}
\donttest{
cma_model <- psma(yi, vi, data = metafor::dat.begg1989, prior = prior)
}
\donttest{
model <- all(yi, vi, data = metafor::dat.begg1989, prior = prior)
}
}
\references{
Hedges, Larry V. "Modeling publication selection effects
in meta-analysis." Statistical Science (1992): 246-255.

Moss, Jonas and De Bin, Riccardo. "Modelling publication
bias and p-hacking" (2019) arXiv:1911.12445
}
