% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_functions.R
\name{coef_det}
\alias{coef_det}
\title{Coefficient of determination.}
\usage{
coef_det(obs, fit)
}
\arguments{
\item{obs}{Vector with observed values (numerical outcome).}

\item{fit}{Vector with fitted (predicted) values.}
}
\value{
A scalar, the coefficient of determination (r-squared).
}
\description{
\code{coef_det} estimates the coefficient of determination (r-squared) from fitted (predicted) and
observed values. Outcome from the model is assumed to be numerical.
}
\examples{
## Linear regression:
Riboflavin <- seq(0, 80, 10)
OD <- 0.0125*Riboflavin + rnorm(9, 0.6, 0.03)
titration <- data.frame(Riboflavin, OD)
model1 <- lm(OD ~ Riboflavin, data = titration)
summary(model1)
coef_det(titration$OD, fitted(model1))

## Non-linear regression:
library(nlme, quietly = TRUE)
data(Puromycin)
mm.tx <- gnls(rate ~ SSmicmen(conc, Vm, K), data = Puromycin,
  subset = state == "treated")
summary(mm.tx)
coef_det(Puromycin$rate[1:12], mm.tx$fitted)
}
