% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Bernard}
\alias{Bernard}
\title{Survival of patients with sepsis.}
\format{
A labelled tibble with 455 rows and 9 variables:
\describe{
\item{id}{Patient ID}
\item{treat}{Treatment, factor with levels "Placebo" and "Ibuprofen".}
\item{race}{Race/ethnicity, factor with levels "White", "African American" and "Other".}
\item{fate}{Mortality status at 30 days, factor with levels "Alive" and "Dead".}
\item{apache}{Baseline APACHE score.}
\item{o2del}{Oxygen delivery at baseline.}
\item{followup}{Follow-up time in hours.}
\item{temp0}{Baseline temperature in centigrades.}
\item{temp10}{Temperature after 36 hr in centigrades.}
}
}
\source{
Bernard, GR, et al. (1997) The effects of ibuprofen on the physiology and survival of patients
with sepsis, N Engl J Med 336: 912–918.
}
\usage{
Bernard
}
\description{
A randomised, double-blind, placebo-controlled trial of intravenous ibuprofen in 455 patients who
had sepsis, defined as fever, tachycardia, tachypnea, and acute failure of at least one organ system.
}
\examples{
data(Bernard)
require(moonBook)

mytable(fate ~ treat, data = Bernard, show.total = TRUE)

contingency(fate ~ treat, data = Bernard)
}
\keyword{datasets}
