% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_functions.R
\name{logistic_gof}
\alias{logistic_gof}
\title{Goodness of fit for Logistic Regression.}
\usage{
logistic_gof(model)
}
\arguments{
\item{model}{A logistic regression model object.}
}
\description{
\code{logistic_gof} performs the Hosmer and Lemeshow test to test the goodness of fit of a logistic
regression model. This function is part of \code{residuals.lrm} from package \code{rms}.
}
\examples{
data(diet, package = "Epi")
model <- glm(chd ~ fibre, data = diet, family = binomial)
glm_coef(model, labels = c("Constant", "Fibre intake (g/day)"))
logistic_gof(model)
}
\references{
Hosmer DW, Hosmer T, Lemeshow S, le Cessie S, Lemeshow S. A comparison of goodness-of-fit
tests for the logistic regression model. Stat in Med 16:965–980, 1997.
}
\author{
Frank Harell, Vanderbilt University <f.harrell@vanderbilt.edu>
}
