% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap_up.R
\name{wrap_up}
\alias{wrap_up}
\title{Wrap up file execution.}
\usage{
wrap_up(start_time = NULL)
}
\arguments{
\item{start_time}{Optional POSIXct object, created by assigning Sys.time()
to an object prior to executing \code{wrap_up()}.}
}
\value{
Interrupts sequential script execution with an auditory signal. Logs
the elapsed time if start_time is used, outputs the script location.
}
\description{
Used to interrupt sequential script execution while testing or debugging.
Outputs an auditory signal and breaks sequential script execution,
identifying the script at which execution was interrupted.
Is a Sys.time() object is passed to \code{start_time}, messages the elapsed time.
}
\examples{

# halt execution with no timing
try(wrap_up())

# create timing checkpoint
s_time <- Sys.time()
# halt execution with timing
try(wrap_up(s_time))

}
