% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp_features.R
\name{bisq_xy}
\alias{bisq_xy}
\title{Bisquare weighted sum}
\usage{
bisq_xy(base, feat, bandwidth, weight = 1)
}
\arguments{
\item{base}{base dataset (eg gridcells), needs to be SpatialPolygonsDataFrame}

\item{feat}{feature dataset (eg another crime generator), needs to be SpatialPointsDataFrame}

\item{bandwidth}{distances above this value do not contribute to the bi-square weight}

\item{weight}{if 1 (default), does not use attribute weights, else pass in string that is the variable name for weights in \code{feat}}
}
\value{
A vector of bi-square weighted sums
}
\description{
Given a base X/Y dataset, calculates bisquare weighted sums of points from feature dataset
}
\details{
This generates bi-square distance weighted sums of features within specified distance of the \code{base} centroid.
Bisquare weights are calculated as:
\deqn{w_{ij} = [ 1 - (d_{ij}/b)^2 ]^2 }
where d_ij is the Euclidean distance between the base point and and the feature point. If d < b, then w_ij equals 0. These are then multiplied
and summed so each base point gets a cumulative weighted sum. See the GWR book for a reference.
Uses loops and calculates all pairwise distances, so can be slow for large base and feature datasets. Consider
aggregating/weighting feature dataset if it is too slow. Useful for quantifying features nearby (Groff, 2014), or for egohoods
(e.g. spatial smoothing of demographic info, Hipp & Boessen, 2013).
}
\examples{
\donttest{
data(nyc_cafe); data(nyc_bor)
gr_nyc <- prep_grid(nyc_bor,15000)
gr_nyc$bscafe <- bisq_xy(gr_nyc,nyc_cafe,12000)
}

}
\references{
Fotheringham, A. S., Brunsdon, C., & Charlton, M. (2003). G\emph{eographically weighted regression: the analysis of spatially varying relationships}. John Wiley & Sons.

Groff, E. R. (2014). Quantifying the exposure of street segments to drinking places nearby. \emph{Journal of Quantitative Criminology}, 30(3), 527-548.

Hipp, J. R., & Boessen, A. (2013). Egohoods as waves washing across the city: A new measure of “neighborhoods”. Criminology, 51(2), 287-327.
}
\seealso{
\code{\link[=dist_xy]{dist_xy()}} for calculating distance to nearest

\code{\link[=count_xy]{count_xy()}} for counting points inside polygon

\code{\link[=kern_xy]{kern_xy()}} for estimating gaussian density of points for features at base polygon xy coords

\code{\link[=bisq_xy]{bisq_xy()}} to estimate bi-square kernel weights of points for features at base polygon xy coords

\code{\link[=idw_xy]{idw_xy()}} to estimate inverse distance weights of points for features at base polygon xy coords
}
