% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wdd_harm.R
\name{wdd_harm}
\alias{wdd_harm}
\title{Combines Multiple WDD Tests}
\usage{
wdd_harm(est, se, weight, alpha = 0.1, silent = FALSE)
}
\arguments{
\item{est}{vector with WDD estimates (e.g. difference in crime counts for treated vs controls)}

\item{se}{vector with standard errors for WDD estimates}

\item{weight}{vector with weights to aggregate results}

\item{alpha}{scaler alpha level for confidence interval (default \code{0.1})}

\item{silent}{boolean, do not print stat messages (default \code{FALSE})}
}
\value{
A length 5 vector with names:
\itemize{
\item \code{HarmEst}, the combined harm estimate
\item \code{SE_HarmEst} its standard error
\item \code{Z}, the Z-score
\item and the lower and upper confidence intervals, \code{LowCI} and \code{HighCI}, for whatever alpha level you specified.
}
}
\description{
Combines multiple weighted displacement difference tests into one final weighted harm metric.
}
\details{
This test combines multiple wdd estimates with different weights. Created to \href{https://andrewpwheeler.com/2020/11/19/amending-the-wdd-test-to-incorporate-harm-weights/}{combine tests for crime harm weights}.
}
\examples{
# Creating wdd tests for three different crimes and combining
rob <- wdd(c(20,20),c(20,10))
burg <- wdd(c(30,30),c(25,20))
theft <- wdd(c(80,60),c(70,20))
dat = data.frame(rbind(rob,burg,theft))
# passing those columns now to the wdd_harm function
harm_weights <- c(10,5,1)
wdd_harm(dat$Est_Local,dat$SE_Local,harm_weights)
}
\seealso{
\code{\link[=wdd]{wdd()}} for estimating the individual wdd outcomes
}
