% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evolutionary.R
\name{list.hom}
\alias{list.hom}
\title{Search Homologous Entries}
\usage{
list.hom(target, homology = 'o')
}
\arguments{
\item{target}{the KEGG identifier of the protein of interest.}

\item{homology}{one letter indicating the type of homology. It should be either 'o' (orthologs) or 'p' (paralogs).}
}
\value{
Returns a dataframe with the requested entries.
}
\description{
Searches for homologous entries.
}
\details{
This application rests on the KEGG Sequence Similarity Database, which contains the information about amino acid sequence similarities among all protein-coding genes in the complete genomes, as well as the addendum and virus categories, of the GENES database.
}
\examples{
\dontrun{list.hom('hsa:2744', hom = 'p')}
}
\references{
Kanehisa et al (2017) Nucl. Ac. Res. 33:D353-D361.
}
\seealso{
msa(), custom.aln(), parse.hssp(), get.hssp(), shannon()
}
\author{
Juan Carlos Aledo
}
