% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_graph_theme.R
\name{apply_graph_theme}
\alias{apply_graph_theme}
\title{Apply multiple DiagrammeR global graph attributes}
\usage{
apply_graph_theme(dctGraph, ...)
}
\arguments{
\item{dctGraph}{The \link[DiagrammeR:DiagrammeR]{DiagrammeR::DiagrammeR} graph to apply the attributes to.}

\item{...}{One or more character vectors of length three, where the first element is
the attribute, the second the value, and the third, the attribute type (\code{graph},
\code{node}, or \code{edge}).}
}
\value{
The \link[DiagrammeR:DiagrammeR]{DiagrammeR::DiagrammeR} graph.
}
\description{
Apply multiple DiagrammeR global graph attributes
}
\examples{
exampleSpec <-
  system.file("inst",
              "extdata",
              "example_dct_spec_1.dct",
              package="psyverse");
parsedSpecs <- load_dct_specs(exampleSpec);
dctGraph <- parsedSpecs$output$basic_graph;
dctGraph <- apply_graph_theme(dctGraph,
                              c("color", "#0000AA", "node"),
                              c("fillcolor", "#00FFFF", "node"));
}
