% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscellaneous.R
\name{power_analysis}
\alias{power_analysis}
\title{Power analysis for fitted models.}
\usage{
power_analysis(
  fit,
  n_max,
  n_min = NULL,
  step = 1,
  n_batch = 1,
  groups = NULL,
  verbose = TRUE,
  CI = 90
)
}
\arguments{
\item{fit}{A lm or stanreg model.}

\item{n_max}{Max sample size.}

\item{n_min}{Min sample size. If null, take current nrow.}

\item{step}{Increment of the sequence.}

\item{n_batch}{Number of iterations at each sample size.}

\item{groups}{Grouping variable name (string) to preserve proportions. Can be a list of strings.}

\item{verbose}{Print progress.}

\item{CI}{Confidence level.}
}
\value{
A dataframe containing the summary of all models for all iterations.
}
\description{
Compute the n models based on n sampling of data.
}
\examples{
\dontrun{
library(dplyr)
library(psycho)

fit <- lm(Sepal.Length ~ Sepal.Width, data = iris)

results <- power_analysis(fit, n_max = 300, n_min = 100, step = 5, n_batch = 20)

results \%>\%
  filter(Variable == "Sepal.Width") \%>\%
  select(n, p) \%>\%
  group_by(n) \%>\%
  summarise(
    p_median = median(p),
    p_mad = mad(p)
  )
}

}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
