% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rnorm_perfect.R
\name{rnorm_perfect}
\alias{rnorm_perfect}
\title{Perfect Normal Distribution.}
\usage{
rnorm_perfect(n, mean = 0, sd = 1, method = "qnorm", iter = 10000)
}
\arguments{
\item{n}{number of observations. If length(n) > 1, the length is taken to be the number required.}

\item{mean}{vector of means.}

\item{sd}{vector of standard deviations.}

\item{method}{"qnorm" or "average".}

\item{iter}{number of iterations (precision).}
}
\description{
Generates a sample of size n with a near-perfect normal distribution.
}
\examples{
library(psycho)
x <- rnorm_perfect(10)
plot(density(x))
}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
