% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_artifacts.R
\name{estimate_rel_dist}
\alias{estimate_rel_dist}
\title{Estimate descriptive statistics of reliabilities}
\usage{
estimate_rel_dist(mean_q, var_q)
}
\arguments{
\item{mean_q}{Mean square-root reliability value.}

\item{var_q}{Variance of square-root reliability values.}
}
\value{
The estimated mean and variance of a distribution of reliability values.
}
\description{
\loadmathjax
Estimate descriptive statistics of reliabilities from descriptive statistics of square-root reliabilities via Taylor series approximation
}
\details{
\mjdeqn{var_{\rho_{XX}}=4q_{X}^{2}var_{\rho_{XX}}}{4 * mean_q^2 * var_q}
}
\examples{
estimate_rel_dist(mean_q = .9, var_q = .05)
}
