% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_error.R
\name{var_error_q}
\alias{var_error_q}
\title{Estimate the error variance of square roots of reliability estimates}
\usage{
var_error_q(q, n, rel_type = "alpha", k_items = NULL)
}
\arguments{
\item{q}{Vector of square roots of reliability estimates.}

\item{n}{Vector of sample sizes.}

\item{rel_type}{Character vector indicating the type(s) of reliabilities being analyzed. See documentation for \code{\link[=ma_r]{ma_r()}} for a full list of acceptable reliability types.
NOTE: Currently, only alpha has its own dedicated error-variance estimate; the error variance of other reliability types is estimated using the generic definition of reliability as the squared correlation between observed scores and true scores.}

\item{k_items}{Optional numeric vector indicating the number of items in each scale for which reliabilities are being analyzed.}
}
\value{
A vector of sampling-error variances.
}
\description{
\loadmathjax
Estimate error variance for square-root reliability coefficients (measure quality indices; \mjeqn{\sqrt{r_{xx}}}{\sqrt(r_XX)} or \mjeqn{q_{XX}}{q_XX}).
}
\details{
The sampling variance of the square root of a reliability coefficient is:

\mjdeqn{var_{e}=\frac{(1-q_{X}^{2})^{2}}{n-1}}{var_e = (1 - qx^2)^2 / (n - 1)}

For the equation to estimate the variance of coefficient alpha, see Duhachek and Iacobucci (2004).
}
\examples{
var_error_q(q = .8, n = 100)
var_error_q(q = .8, n = 100, rel_type = "alpha", k_items = 10)
}
\references{
Dahlke, J. A., & Wiernik, B. M. (2020). Not restricted to selection research:
Accounting for indirect range restriction in organizational research.
\emph{Organizational Research Methods, 23}(4), 717–749. \doi{10.1177/1094428119859398}

Duhachek, A., & Iacobucci, D. (2004).
Alpha’s standard error (ASE): An accurate and precise confidence interval estimate.
\emph{Journal of Applied Psychology, 89}(5), 792–808. \doi{10.1037/0021-9010.89.5.792}
}
