% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{record_fyis}
\alias{record_fyis}
\title{Summary of FYI messages generated within a function}
\usage{
record_fyis(es_metric = "r", fyi_messages = NULL, neg_var_res = 0,
  neg_var_rtpa = 0, neg_var_rxpa = 0, neg_var_rtya = 0,
  neg_var_r_order2 = 0, neg_var_rho_ic_order2 = 0,
  neg_var_rho_ad_order2 = 0, neg_var_d_order2 = 0,
  neg_var_delta_ic_order2 = 0, neg_var_delta_ad_order2 = 0)
}
\arguments{
\item{es_metric}{Effect-size metric ("r" or "d").}

\item{fyi_messages}{Vector of assorted FYI messages accumulated during function.}

\item{neg_var_res}{Number of negative residual variances}

\item{neg_var_rtpa}{Number of negative true-score variances.}

\item{neg_var_rxpa}{Number of negative validity generalization variances (X as predictor).}

\item{neg_var_rtya}{Number of negative validity generalization variances (Y as predictor).}

\item{neg_var_r_order2}{Variance of mean r from second-order bare-bones meta-analysis.}

\item{neg_var_rho_ic_order2}{Variance of mean r from second-order individual-correction meta-analysis.}

\item{neg_var_rho_ad_order2}{Variance of mean r from second-order artifact-distribution meta-analysis.}

\item{neg_var_d_order2}{Variance of mean d from second-order bare-bones meta-analysis.}

\item{neg_var_delta_ic_order2}{Variance of mean d from second-order individual-correction meta-analysis.}

\item{neg_var_delta_ad_order2}{Variance of mean d from second-order artifact-distribution meta-analysis.}
}
\value{
Table of FYI messages and message frequencies.
}
\description{
Summary of FYI messages generated within a function
}
\keyword{internal}
