% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reshape.R
\name{reshape_vec2mat}
\alias{reshape_vec2mat}
\title{Assemble a variance-covariance matrix}
\usage{
reshape_vec2mat(cov = NULL, var = NULL, order = NULL, var_names = NULL)
}
\arguments{
\item{cov}{Scalar or vector of covariance information to include the off-diagonal positions of the matrix (default value is zero).
If a vector, the elements must be provided in the order associated with concatenated column vectors of the lower triangle of the desired matrix,
which is the order or elements that would occur if the lower triangle of the desired matrix were extracted with the following R function: x[lower.tri(x)].}

\item{var}{Scalar or vector of variance information to include the diagonal positions of the matrix (default value is 1).}

\item{order}{If cov and var are scalars, this argument determines the number of variables to create in the output matrix.}

\item{var_names}{Optional vector of variable names.}
}
\value{
A variance-covariance matrix
}
\description{
The \code{reshape_vec2mat} function facilitates the creation of square correlation/covariance matrices from scalars or vectors of variances/covariances.
It allows the user to supply a vector of covariances that make up the lower triangle of a matrix, determines the order of the matrix necessary to hold those covariances, and constructs a matrix accordingly.
}
\examples{
## Specify the lower triangle covariances
## Can provide names for the variables
reshape_vec2mat(cov = c(.3, .2, .4), var_names = c("x", "y", "z"))

## Specify scalar values to repeat for the covariances and variances
c(cov = .3, var = 2, order = 3)

## Give a vector of variances to create a diagonal matrix
reshape_vec2mat(var = 1:5)

## Specify order only to create identity matrix
reshape_vec2mat(order = 3)

## Specify order and scalar variance to create a scalar matrix
reshape_vec2mat(var = 2, order = 3)

## A quick way to make a 2x2 matrix for bivariate correlations
reshape_vec2mat(cov = .2)
}
