% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ma_generic.R
\name{ma_r_generic}
\alias{ma_r_generic}
\title{Bare-bones meta-analysis of generic effect sizes}
\usage{
ma_r_generic(es, n, var_e, sample_id = NULL, wt_type = "sample_size",
  conf_level = 0.95, cred_level = 0.8, conf_method = "t",
  cred_method = "t", var_unbiased = TRUE, moderators = NULL,
  cat_moderators = TRUE, moderator_type = "simple", hs_override = FALSE,
  data = NULL, ...)
}
\arguments{
\item{es}{Vector or column name of observed effect sizes.}

\item{n}{Vector or column name of sample sizes.}

\item{var_e}{Vector or column name of error variances.}

\item{sample_id}{Optional vector of identification labels for samples/studies in the meta-analysis.
When \code{TRUE}, program will use sample-size weights, error variances estimated from the mean effect size, maximum likelihood variances, and normal-distribution confidence and credibility intervals.}

\item{wt_type}{Type of weight to use in the meta-analysis: native options are "sample_size", and "inv_var" (inverse error variance).
Supported options borrowed from metafor are "DL", "HE", "HS", "SJ", "ML", "REML", "EB", and "PM"
(see metafor documentation for details about the metafor methods).}

\item{conf_level}{Confidence level to define the width of the confidence interval (default = .95).}

\item{cred_level}{Credibility level to define the width of the credibility interval (default = .80).}

\item{conf_method}{Distribution to be used to compute the width of confidence intervals. Available options are "t" for \emph{t} distribution or "norm" for normal distribution.}

\item{cred_method}{Distribution to be used to compute the width of credibility intervals. Available options are "t" for \emph{t} distribution or "norm" for normal distribution.}

\item{var_unbiased}{Logical scalar determining whether variances should be unbiased (\code{TRUE}) or maximum-likelihood (\code{FALSE}).}

\item{moderators}{Matrix of moderator variables to be used in the meta-analysis (can be a vector in the case of one moderator).}

\item{cat_moderators}{Logical scalar or vector identifying whether variables in the \code{moderators} argument are categorical variables (\code{TRUE}) or continuous variables (\code{FALSE}).}

\item{moderator_type}{Type of moderator analysis ("none", "simple", or "hierarchical").}

\item{hs_override}{When TRUE, this will override settings for \code{wt_type} (will set to "sample_size"),
\code{conf_method} (will set to "norm"), \code{cred_method} (will set to "norm"), and \code{var_unbiased} (will set to \code{FALSE}).}

\item{data}{Data frame containing columns whose names may be provided as arguments to vector arguments and/or moderators.}

\item{...}{Further arguments to be passed to functions called within the meta-analysis.}
}
\value{
A list object of the classes \code{psychmeta}, \code{ma_generic}, and \code{ma_bb}.
}
\description{
This function computes bare-bones meta-analyses of any effect size using user-supplied effect error variances.
}
\examples{
es <- c(.3, .5, .8)
n <- c(100, 200, 150)
var_e <- 1 / n
ma_r_generic(es = es, n = n, var_e = var_e)
}
