% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{printTable}
\alias{printTable}
\title{printTable}
\usage{
printTable(
  obj,
  caption = "DF",
  digits = 3,
  onlyContents = FALSE,
  formatStatsSymbols = TRUE
)
}
\arguments{
\item{obj}{Dataframe/ezANOVA object to print}

\item{caption}{Title of the dataframe}

\item{digits}{Number of digits to round to NB. length can be 1, or vector with
length equal to the number of numeric columns}

\item{onlyContents}{TRUE/FALSE}

\item{formatStatsSymbols}{TRUE/FALSE}
}
\value{
character
}
\description{
Returns Latex formatted table from dataframe or ezANOVA ANOVA table.
Uses xtable latex package with some basic defaults.
For more examples, see R package xtable
}
\examples{
requiredPackages(c("dplyr", "ez"))

# Example 1:
# create dataframe
dat <- createDF(nVP = 6, nTrl = 1,
                design = list("Comp" = c("comp", "incomp")))

dat <- addDataDF(dat, RT = list("Comp_comp"   = c(500, 150, 100),
                                "Comp_incomp" = c(520, 150, 100)))
printTable(dat) # latex formatted

dat$VP <- as.factor(dat$VP)
aovRT <- ezANOVA(dat, dv=.(RT), wid = .(VP), within = .(Comp),
                 return_aov = TRUE, detailed = TRUE)
aovRT <- aovTable(aovRT)
printTable(aovRT$ANOVA) # latex formatted

}
