% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ttest.R
\name{ciStrT}
\alias{ciStrT}
\title{ciStrT}
\usage{
ciStrT(tObj, numDigits = 0, unit = "")
}
\arguments{
\item{tObj}{The returned object from a call to t.test}

\item{numDigits}{The number of digits to round to}

\item{unit}{"" vs. "ms" vs. "mv" vs. "\%"}
}
\value{
character
}
\description{
Returns a string with the 95\% CI from a t.test in Latex format.
}
\examples{
requiredPackages(c("dplyr"))

# Example 1:
# create dataframe and add data with 2(Comp: comp vs. incomp) levels
dat <- createDF(nVP = 20,
                nTrl = 50,
                design = list("Comp" = c("comp", "incomp")))

dat <- addDataDF(dat, RT = list("Comp_comp"   = c(500, 150, 100),
                                "Comp_incomp" = c(520, 150, 100)))

# aggregate dat across trials
datAggVP <- dat \%>\%
    group_by(VP, Comp) \%>\%
    summarize(N  = n(),
              rt = mean(RT))

tObj <- t.test(datAggVP$rt[datAggVP$Comp == "comp"],
               datAggVP$rt[datAggVP$Comp == "incomp"],
               paired = TRUE)

ciString <- ciStrT(tObj, unit = "ms")

}
