% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_terms.R
\name{plot_terms}
\alias{plot_terms}
\title{Plot terms of the non-parametric covariates in the
  semiparametric regression models.}
\usage{
plot_terms(
  fitterms,
  data,
  type = "global",
  alpha = 0.05,
  listw = NULL,
  dynamic = FALSE,
  nt = NULL,
  decomposition = FALSE
)
}
\arguments{
\item{fitterms}{object returned from \code{\link{fit_terms}} function.}

\item{data}{dataframe or sf with the data.}

\item{type}{type of term plotted between "global" (Default), 
"fixed" or "random".}

\item{alpha}{numerical value for the significance level of the pointwise 
confidence intervals of the nonlinear terms. Default 0.05.}

\item{listw}{used to compute spatial lags for Durbin specifications. 
Default =  `NULL`}

\item{dynamic}{Logical value to set a dynamic model.
Dynamic models include a temporal lag of the dependent
variable in the right-hand side of the equation.
Default = `FALSE`.}

\item{nt}{Number of temporal periods. It is needed
for dynamic models.}

\item{decomposition}{Plot the decomposition of term in
random and fixed effects.}
}
\value{
list with the plots of the terms for each non-parametric 
  covariate included in the object returned from \code{\link{fit_terms}}.
}
\description{
For each non-parametric covariate the plot of the term
  includes confidence intervals and the decomposition in fixed and 
  random part when the term is reparameterized as a mixed model.
}
\examples{
################################################
# Examples using spatial data of Ames Houses.
###############################################
# Getting and preparing the data
library(pspatreg)
library(spdep)
library(sf)
ames <- AmesHousing::make_ames() # Raw Ames Housing Data
ames_sf <- st_as_sf(ames, coords = c("Longitude", "Latitude"))
ames_sf$Longitude <- ames$Longitude
ames_sf$Latitude <- ames$Latitude
ames_sf$lnSale_Price <- log(ames_sf$Sale_Price)
ames_sf$lnLot_Area <- log(ames_sf$Lot_Area)
ames_sf$lnTotal_Bsmt_SF <- log(ames_sf$Total_Bsmt_SF+1)
ames_sf$lnGr_Liv_Area <- log(ames_sf$Gr_Liv_Area)
ames_sf1 <- ames_sf[(duplicated(ames_sf$Longitude) == FALSE), ]
                    
form1 <- lnSale_Price ~ Fireplaces + Garage_Cars +
          pspl(lnLot_Area, nknots = 20) + 
          pspl(lnTotal_Bsmt_SF, nknots = 20) +
          pspl(lnGr_Liv_Area, nknots = 20)    

\donttest{ 
########### Constructing the spatial weights matrix
coord_sf1 <- cbind(ames_sf1$Longitude, ames_sf1$Latitude)
k5nb <- knn2nb(knearneigh(coord_sf1, k = 5, 
                          longlat = TRUE, use_kd_tree = FALSE), sym = TRUE)
lw_ames <- nb2listw(k5nb, style = "W", 
                  zero.policy = FALSE)
gamsar <- pspatfit(form1, data = ames_sf1, 
                   type = "sar", listw = lw_ames,
                   method = "Chebyshev")
summary(gamsar)
list_varnopar <- c("lnLot_Area", "lnTotal_Bsmt_SF", 
"lnGr_Liv_Area")
terms_nopar <- fit_terms(gamsar, list_varnopar)
######################  Plot non-parametric terms
plot_terms(terms_nopar, ames_sf1)

###### Examples using a panel data of rate of
###### unemployment for 103 Italian provinces in period 1996-2014.
library(pspatreg)
data(unemp_it, package = "pspatreg")
lwsp_it <- spdep::mat2listw(Wsp_it)

########  No Spatial Trend: ps-sar including a spatial 
########  lag of the dependent variable
form1 <- unrate ~ partrate + agri + cons + 
                  pspl(serv,nknots = 15) +
                  pspl(empgrowth,nknots = 20) 
gamsar <- pspatfit(form1, data = unemp_it, 
                   type = "sar", listw = Wsp_it)
summary(gamsar)
########  Fit non-parametric terms (spatial trend must be name "spttrend")
list_varnopar <- c("serv", "empgrowth")
terms_nopar <- fit_terms(gamsar, list_varnopar)
#######  Plot non-parametric terms
plot_terms(terms_nopar, unemp_it)
}  
}
\references{
\itemize{ 
  \item Wood, S.N. (2017). \emph{Generalized Additive Models. 
  An Introduction with \code{R}} (second edition). CRC Press, Boca Raton.
 }
}
\seealso{
\itemize{
  \item \code{\link{fit_terms}} compute smooth functions for non-parametric
                                continuous covariates.
  \item \code{\link{impactsnopar}} plot the effects functions 
    of non-parametric covariates.
  \item \code{\link[mgcv]{vis.gam}} plot the terms fitted by 
    \code{\link[mgcv]{gam}} function in \pkg{mgcv} package.   
}
}
\author{
\tabular{ll}{ 
  Roman Minguez  \tab \email{roman.minguez@uclm.es} \cr
  Roberto Basile \tab \email{roberto.basile@univaq.it} \cr Maria Durban \tab
  \email{mdurban@est-econ.uc3m.es} \cr Gonzalo Espana-Heredia \tab
  \email{gehllanza@gmail.com} \cr 
 }
}
