% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_pspatreg.R
\name{methods_pspatreg}
\alias{methods_pspatreg}
\alias{anova}
\alias{anova.pspatreg}
\alias{coef}
\alias{coef.pspatreg}
\alias{fitted}
\alias{fitted.pspatreg}
\alias{logLik}
\alias{logLik.pspatreg}
\alias{residuals}
\alias{residuals.pspatreg}
\alias{vcov}
\alias{vcov.pspatreg}
\alias{print}
\alias{print.pspatreg}
\title{Methods for class pspatreg}
\usage{
\method{anova}{pspatreg}(object, ..., lrtest = TRUE)

\method{coef}{pspatreg}(object, ...)

\method{fitted}{pspatreg}(object, ...)

\method{logLik}{pspatreg}(object, ..., REML = FALSE)

\method{residuals}{pspatreg}(object, ...)

\method{vcov}{pspatreg}(object, ..., bayesian = FALSE)

\method{print}{pspatreg}(x, digits = max(3L, getOption("digits") - 3L), ...)
}
\arguments{
\item{object}{a `pspatreg` object created by 
\code{\link{pspatfit}}.}

\item{...}{further arguments passed to or from other methods.}

\item{lrtest}{logical value to compute likelihood ratio
test for nested models in `anova` method. Default = `TRUE`}

\item{REML}{logical value to get restricted log-likelihood 
instead of the usual log-likelihood. Default = `FALSE`}

\item{bayesian}{logical value to get bayesian or frequentist
covariance matrix for parametric terms. Default = `FALSE`}

\item{x}{similar to \code{object} argument for \code{print()} 
and \code{plot} functions.}

\item{digits}{number of digits to show in printed tables.
Default: max(3L, getOption("digits") - 3L).}
}
\value{
\code{anova:} An object of class \emph{anova}. Can be printed
  with \code{summary}. 
  If argument \code{lrtest = TRUE} (default), the object 
  returned includes an LR test for nested models. 
  In this case, a warning message is printed to emphasize 
  that the LR test remains valid only for nested models.

\code{coef:} A numeric vector including spatial parameters and
  parameters corresponding to parametric covariates. 
  Also includes fixed parameters for non-parametric 
  covariates. Can be printed with \code{print}.

\code{fitted:} A numeric vector including fitted values for the 
  dependent variable.

\code{logLik:} An object of class \emph{logLik}. Can be printed
  with \code{print}.
  If argument \code{REML = FALSE} (default), the object returns 
  the value of log-likelihood function in the optimum. 
  If argument \code{REML = TRUE}, the object returns 
  the value of restricted log-likelihood function in 
  the optimum.

\code{residuals:} A numeric vector including residuals of the model.

\code{vcov:} A matrix including the covariance matrix for the
  estimated parameters.
  If argument \code{bayesian = FALSE} (default), the 
  covariance matrix is computed using sandwich (frequentist)
  method. 
  If argument \code{bayesian = TRUE} , the 
  covariance matrix is computed using bayesian method. 
  See Fahrmeir et al. (2021) for details.

\code{print:} No return value
}
\description{
The \code{\link{anova}} function provides tables of fitted 
  `pspatreg` models including information criteria (AIC and BIC), 
  log-likelihood and degrees of freedom of each fitted model. The 
  argument `lrtest` allows to perform LR tests between nested models.
  The \code{\link{print}} function is used to print short tables including the 
  values of beta and spatial coefficients as well as p-values of significance test for each 
  coefficient. This can be used as an alternative to 
 \code{\link{summary.pspatreg}} when a brief output is needed. 
 The rest of methods works in the usual way.
}
\examples{
library(pspatreg)
## load spatial panel and Wsp_it
## 103 Italian provinces. Period 1996-2019
data(unemp_it, package = "pspatreg")
## Wsp_it is a matrix. Create a neighboord list 
lwsp_it <- spdep::mat2listw(Wsp_it)
## short sample for spatial pure case (2d)
unemp_it_short <- unemp_it[unemp_it$year == 2019, ]
####  GAM pure with pspatreg
form1 <- unrate ~ partrate + agri + cons +
                 pspl(serv, nknots = 15) +
                 pspl(empgrowth, nknots = 20)
gampure <- pspatfit(form1, data = unemp_it_short)
summary(gampure)

#####################  GAM + SAR Model
gamsar <- pspatfit(form1, data = unemp_it_short, 
                   type = "sar", listw = lwsp_it)
summary(gamsar)
### Test nested models
anova(gampure, gamsar)
### anova without testing
anova(gampure, gamsar, lrtest = FALSE)
## logLikelihood 
logLik(gamsar)
## Restricted logLikelihood
logLik(gamsar, REML = TRUE)
## Parametric and spatial coefficients
print(gamsar)
coef(gamsar)
## Frequentist (sandwich) covariance matrix 
## (parametric terms)
vcov(gamsar)      
## Bayesian covariance matrix (parametric terms)
vcov(gamsar, bayesian = TRUE)
#####################################
#### Fitted Values and Residuals
plot(gamsar$fitted.values, 
     unemp_it_short$unrate, 
     xlab = 'fitted values', 
     ylab = "unrate",
     type = "p", cex.lab = 1.3, 
     cex.main = 1.3,
     main = "Fitted Values gamsar model")      
plot(gamsar$fitted.values, gamsar$residuals, 
     xlab = 'fitted values', ylab = "residuals",
     type = "p", cex.lab = 1.3, cex.main=1.3,
     main = "Residuals geospsar model")
     
}
\references{
\itemize{ 
    \item Fahrmeir, L.; Kneib, T.;  Lang, S.; and Marx, B. (2021). 
      \emph{Regression. Models, Methods and Applications (2nd Ed.)}.
     Springer.
   }
}
\author{
\tabular{ll}{
    Roman Minguez \tab \email{roman.minguez@uclm.es} \cr
    Roberto Basile \tab \email{roberto.basile@univaq.it} \cr
    Maria Durban \tab \email{mdurban@est-econ.uc3m.es} \cr
    Gonzalo Espana-Heredia \tab \email{gehllanza@gmail.com} \cr
  }
}
