% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting.R
\name{find_bestfit}
\alias{find_bestfit}
\title{Find the "best" survival regression from a list of model fits}
\usage{
find_bestfit(reglist, crit)
}
\arguments{
\item{reglist}{List of fitted survival regressions to an endpoint and dataset.}

\item{crit}{Criterion to be used in selection of best fit, either "aic" (Akaike Information Criterion) or "bic" (Bayesian Information Criterion).}
}
\value{
List of the single survival regression with the best fit.
}
\description{
When there are multiple survival regressions fitted to the same endpoint and dataset, it is necessary to identify the preferred model. This function reviews the fitted regressions and selects that with the minimum Akaike or Bayesian Information Criterion (AIC, BIC), depending on user choice. Model fits must be all parametric or all splines.
}
\examples{
bosonc <- create_dummydata("flexbosms")
# Parametric modeling
fits_par <- fit_ends_mods_par(bosonc)
find_bestfit(fits_par$ttp, "aic")
\donttest{
# Splines modeling
fits_spl <- fit_ends_mods_spl(bosonc)
find_bestfit(fits_spl$ttp, "bic")
}
}
