% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/psd-package.R
\docType{data}
\name{magnet}
\alias{magnet}
\title{A single line of Project MAGNET horizontal field intensity}
\format{A dataframe with 2048 observations on the following 4 variables.

\describe{
\item{\code{km}}{Relative along-track distance, in kilometers. The first observation is at zero kilometers.}
\item{\code{raw}}{Raw intensities, in nanotesla.}
\item{\code{clean}}{Edited raw intensites, in nanotesla}
\item{\code{mdiff}}{The difference between \code{clean} and \code{raw} intensities, in nanotesla.}
}}
\source{
Project MAGNET page: \url{http://www.ngdc.noaa.gov/geomag/proj_mag.shtml}
}
\description{
The Project MAGNET mission
provided a wealth of airborne-magnetometer data
spanning the globe (Coleman, 1992).
This dataset represents a single track of horizontal field
intensities (a very small subset of the full collection!).
}
\details{
\subsection{Raw and Clean Sets}{
There are non-real data points in raw MAGNET series; these are
instrumental artefacts, and can severely affect
power spectral density (PSD) estimates.
A clean series has been included
so that a comparison of PSDs may be made.

Some command like \code{subset(magnet, abs(mdiff) > 0)}
can be used to identify the rows where edits have been made.
}
}
\examples{
data(magnet)
summary(magnet)
}
\references{
Coleman, R. J. (1992),
Project Magnet high-level vector survey data reduction.
In \emph{Types and Characteristics of Data for Geomagnetic Field Modeling},
\strong{3153}, pp. 215-248.
}
\seealso{
\code{\link{pspectrum}}, \code{\link{Tohoku}}, \code{\link{hfsnm}}
}
\keyword{datasets}

