% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/func_psdcore.R
\name{psdcore}
\alias{psdcore}
\alias{psdcore.default}
\alias{psdcore.ts}
\title{Multitaper power spectral density estimates of a series}
\usage{
psdcore(X.d, ...)

\method{psdcore}{ts}(X.d, ...)

\method{psdcore}{default}(X.d, X.frq = NULL, ntaper = as.tapers(5),
  preproc = TRUE, na.action = stats::na.fail, plot = FALSE,
  refresh = FALSE, verbose = FALSE, ndecimate, ...)
}
\arguments{
\item{X.d}{the series to estimate a spectrum for}

\item{...}{additional parameters}

\item{X.frq}{scalar; the sampling information (see section Sampling)}

\item{ntaper}{scalar, vector, or \code{\link{tapers}}; the number of sine tapers to apply at each frequency}

\item{preproc}{logical; should \code{X.d} have a linear trend removed?}

\item{na.action}{function to deal with \code{NA} values}

\item{plot}{logical; should the estimates be shown compared to the \code{\link[stats]{spectrum}}-based estimates?
Note that this will add some computation time, since the cosine-tapered periodogram is calculated inside
\code{\link{pgram_compare}}.}

\item{refresh}{logical; ensure a free environment prior to execution}

\item{verbose}{logical; should warnings and messages be given?}

\item{ndecimate}{now ignored}
}
\value{
An on object of class \code{'amt','spec'}, which has a structure similar to a regular \code{'spec'} object,
but with a few additional fields, invisibly.
}
\description{
Compute power spectral density (PSD) estimates
for the input series using sine multitapers.
This is used by \code{\link{pspectrum}} for the adaptive
estimation procedure.
}
\details{
\subsection{Tapering}{
The parameter \code{ntaper} specifies the number of sine tapers to be used
at each frequency: equal tapers at each frequency for a scalar;
otherwise, use \code{ntaper[j]} sine tapers at \code{frequency[j]}.
}

\subsection{Truncation}{
The series, with length \eqn{N}, is necessarily truncated so that \eqn{1+N/2} evenly
spaced frequencies are returned. This truncation makes the series length ``highly composite",
which the discrete Fourier transform (DFT) is most efficient.
The "fftw" vignette (accessed with \code{vignette("fftw",package="psd")}) shows
how the performance of a DFT can be affected by series length.
}

\subsection{Decimation}{
	No longer supported. Setting \code{ndecimate} will not affect the results
}

\subsection{Sampling}{
 If \code{X.frq} is NULL, the value is assumed to be 1, unless \code{X.d} is a  \code{'ts'} object.
 If \code{X.frq > 0} it's assumed the value represents \emph{frequency} (e.g. Hz).
 If \code{X.frq < 0} it's assumed the value represents \emph{interval} (e.g. seconds).
}
}
\examples{
\dontrun{#REX
library(psd)
##
## Multitaper PSD estimation
##
set.seed(1234)
X <- rnorm(1e3)
#
# use the defaults, and appeal to plot.spec
plot(psdcore(X))
#
# use more tapers, compare to stats::spectrum, and clear 
# env data from the previous calculation
psdcore(X, ntaper=10, plot=TRUE, refresh=TRUE)
#
# change the sampling frequency to 20
psdcore(X, 20, 10, plot=TRUE, refresh=TRUE) 
}#REX
}
\author{
A.J. Barbour; original algorithm by R.L. Parker.
}
\seealso{
\code{\link{pspectrum}}, \code{\link{riedsid}}, \code{\link{parabolic_weights}}, \code{\link{pgram_compare}}
}

