% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data.R
\name{create_event_dist}
\alias{create_event_dist}
\alias{null_event_dist}
\title{Specify a Time to Event Distribution}
\usage{
create_event_dist(
  dist = NULL,
  lambdas = NULL,
  gammas = NULL,
  mixture = FALSE,
  pmix = 0.5,
  hazard = NULL,
  loghazard = NULL,
  cumhazard = NULL,
  logcumhazard = NULL,
  ...
)

null_event_dist()
}
\arguments{
\item{dist}{Specify the distribution \code{"exponential"}}

\item{lambdas}{Scale parameter}

\item{gammas}{Second parameter needed for Weibull or Gompertz distributions}

\item{mixture}{Use mixture model?}

\item{pmix}{Proportion of mixtures}

\item{hazard}{A user defined hazard function}

\item{loghazard}{Alternatively, a user defined log hazard function}

\item{cumhazard}{Alternatively, a user defined cumulative hazard function}

\item{logcumhazard}{Alternatively, a user defined log cumulative hazard function}

\item{...}{Other \code{simsurv} parameters}
}
\value{
A \code{SimDataEvent} object

\code{null_event_dist} returns an object with no parameters specified that does not simulate event times.
}
\description{
Uses \link[simsurv:simsurv]{simsurv::simsurv} to generate time to event data. See \code{simsurv} help for more details.
}
\examples{
weibull_surv <- create_event_dist(dist = "weibull", lambdas = 1 / 200, gammas = 1)
exp_event_dist <- create_event_dist(dist = "exponential", lambdas = 1 / 36)
null_event_dist()
}
