% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treatment_details.R
\name{treatment_details}
\alias{treatment_details}
\title{Specify Treatment Details}
\usage{
treatment_details(trt_flag_col, trt_prior)
}
\arguments{
\item{trt_flag_col}{character. The name of the column
in the model matrix that corresponds to the treatment flag
(\code{1}/\code{0} or \code{TRUE}/\code{FALSE}). This identifies patients as belonging
to the experimental treatment arm.}

\item{trt_prior}{Object of class \code{Prior} specifying the
prior distribution of the log effect estimate (log hazard ratio for
time to event endpoints and log odds ratio for binary endpoints).}
}
\value{
Object of class \code{\link[=Treatment-class]{Treatment}}.
}
\description{
Specify the treatment arm column name in the model matrix and set a prior
distribution for the treatment effect (log hazard ratio or
log odds ratio)
}
\examples{
sta <- treatment_details(
  trt_flag_col = "trt",
  trt_prior = prior_normal(0, 1000)
)
}
