% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transport.R
\name{Wasserstein.diss}
\alias{Wasserstein.diss}
\alias{Wasserstein.diss.default}
\alias{Wasserstein.diss.distributional}
\alias{Wasserstein.diss.varietal}
\title{Wasserstein distance}
\usage{
Wasserstein.diss(x, ...)

\method{Wasserstein.diss}{default}(x, y, ...)

\method{Wasserstein.diss}{distributional}(x, log = FALSE, ...)

\method{Wasserstein.diss}{varietal}(
  x,
  package = "approxOT",
  OTmethod = "sinkhorn",
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{the first sample as a vector}

\item{...}{optional arguments to the
\code{transport::wasserstein()} or
\code{approxOT::wasserstein()} functions.}

\item{y}{the second sample as a vector}

\item{log}{logical. Take the lograthm of the data before
calculating the distances?}

\item{package}{the name of the package that provides the 2D
Wasserstein distance. Currently, this can be either
\code{'transport'} or \code{approxOT}.}

\item{OTmethod}{only relevant if \code{package='approxOT'}. Passed
on to the argument \code{method} of
\code{approxOT::wasserstein}. See
\code{?approxOT:transport_options} for details.}

\item{verbose}{logical. If \code{TRUE}, gives progress updates
during the construction of the dissimilarity matrix.}
}
\value{
a scalar value
}
\description{
Returns the Wasserstein distance between two samples
}
\examples{
data(Namib)
print(Wasserstein.diss(Namib$DZ$x[['N1']],Namib$DZ$x[['T8']]))
}
\author{
The default S3 method was written by Pieter Vermeesch,
    using modified code from Dominic Schuhmacher's \code{transport}
    package (\code{transport1d} function), as implemented in
    \code{IsoplotR}.
}
