% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.ternary}
\alias{plot.ternary}
\title{Plot a ternary diagram}
\usage{
\method{plot}{ternary}(x, type = "empty", pch = NA, labels = names(x),
  showpath = FALSE, ...)
}
\arguments{
\item{x}{an object of class \code{ternary}}

\item{type}{adds annotations to the ternary diagram, one of either
\code{empty}, \code{QFL}, \code{QFL.dickinson} or
\code{QmFLt.dickinson}}

\item{pch}{plot character, see \code{?par} for details}

\item{labels}{vector of strings to be added to the plot symbols}

\item{showpath}{if \code{x} has class \code{SRDcorrected}, and
\code{showpath}==TRUE, the intermediate values of the SRD correction
will be plotted on the ternary diagram as well as the final composition}

\item{...}{optional arguments to the generic \code{points} function}
}
\description{
Plots triplets of compositional data on a ternary diagram
}
\examples{
data(Namib)
tern <- ternary(Namib$PT,'Q',c('KF','P'),c('Lm','Lv','Ls'))
plot(tern,type='QFL.dickinson')
}
\seealso{
ternary
}

