/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class TestTree
extends JPanel {
    private JTree tree;
    private int selectionWidth;

    public TestTree() {
        JCheckBox jCheckBox = new JCheckBox();
        this.selectionWidth = jCheckBox.getPreferredSize().width;
        SelectionNode selectionNode = new SelectionNode("root");
        SelectionNode selectionNode2 = new SelectionNode("node1");
        selectionNode2.add(new SelectionNode("node11"));
        selectionNode2.add(new SelectionNode("node12"));
        selectionNode.add(selectionNode2);
        selectionNode.add(new SelectionNode("node2"));
        selectionNode.add(new SelectionNode("node3"));
        this.tree = new JTree(selectionNode);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        this.setLayout(new GridLayout(1, 1));
        this.add(jScrollPane);
        this.tree.setCellRenderer(new SelectionCellRenderer());
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                TreePath treePath = TestTree.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath != null) {
                    Rectangle rectangle = TestTree.this.tree.getPathBounds(treePath);
                    SelectionNode selectionNode = (SelectionNode)treePath.getLastPathComponent();
                    if (rectangle.x + TestTree.this.selectionWidth > mouseEvent.getX()) {
                        selectionNode.selected = !selectionNode.selected;
                        TestTree.this.tree.repaint();
                    }
                }
            }
        });
    }

    public class SelectionCellRenderer
    extends JCheckBox
    implements TreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            if (object instanceof SelectionNode) {
                SelectionNode selectionNode = (SelectionNode)object;
                this.setText(selectionNode.name);
                this.setSelected(selectionNode.selected);
            } else {
                this.setText("");
            }
            if (bl) {
                this.setForeground(UIManager.getColor("Tree.selectionForeground"));
            } else {
                this.setForeground(UIManager.getColor("Tree.textForeground"));
            }
            this.setComponentOrientation(jTree.getComponentOrientation());
            return this;
        }
    }

    public class SelectionNode
    extends DefaultMutableTreeNode {
        public boolean selected;
        public String name;

        public SelectionNode(String string) {
            this.name = string;
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

