/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.stream;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Base64InputStream
extends FilterInputStream {
    private final byte[] store = new byte[3];
    private int pos = 0;
    private boolean endOfStream;
    private int nos = 0;

    public Base64InputStream(InputStream inputStream) {
        super(inputStream);
        if (inputStream == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public int read() throws IOException {
        if (this.pos >= this.nos) {
            this.getStore();
        }
        if (this.endOfStream) {
            return -1;
        }
        return this.store[this.pos++];
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.endOfStream) {
            return -1;
        }
        int n3 = 0;
        while (n3 < n2 && this.pos < this.nos) {
            byArray[n + n3++] = this.store[this.pos++];
        }
        while (n2 - n3 >= this.nos) {
            this.getStore();
            if (this.endOfStream) break;
            while (this.pos < this.nos) {
                byArray[n + n3++] = this.store[this.pos++];
            }
        }
        if (!this.endOfStream) {
            if (this.pos >= this.nos) {
                this.getStore();
            }
            while (!this.endOfStream && n3 < n2) {
                byArray[n + n3++] = this.store[this.pos++];
            }
        }
        return n3;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public void mark() {
    }

    @Override
    public void reset() {
    }

    private void getStore() throws IOException {
        this.pos = 0;
        int n = 0;
        int n2 = 0;
        block4: while (n2 < 4) {
            int n3 = this.in.read();
            if (n3 == -1) {
                this.endOfStream = true;
                return;
            }
            n3 = this.decodeInt(n3);
            switch (n3) {
                case -1: {
                    continue block4;
                }
                case -2: {
                    if (n2 == 2 || n2 == 3) break block4;
                    throw new IOException("Invalid placement of '=' in the stream");
                }
                default: {
                    n = n << 6 | n3;
                    ++n2;
                    continue block4;
                }
            }
        }
        if (n2 == 4) {
            this.nos = 3;
            this.store[2] = (byte)(n & 0xFF);
            this.store[1] = (byte)((n >>= 8) & 0xFF);
            this.store[0] = (byte)((n >>= 8) & 0xFF);
        } else if (n2 == 2) {
            this.nos = 1;
            this.in.read();
            this.store[0] = (byte)((n >>= 4) & 0xFF);
        } else {
            this.nos = 2;
            this.store[1] = (byte)((n >>= 2) & 0xFF);
            this.store[0] = (byte)((n >>= 8) & 0xFF);
        }
    }

    private int decodeInt(int n) {
        if (n >= 65 && n <= 90) {
            return n - 65;
        }
        if (n >= 97 && n <= 122) {
            return n - 97 + 26;
        }
        if (n >= 48 && n <= 57) {
            return n - 48 + 52;
        }
        if (n == 43) {
            return 62;
        }
        if (n == 47) {
            return 63;
        }
        if (n == 61) {
            return -2;
        }
        return -1;
    }
}

