% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc-07-removeGaps.R
\name{removeGaps}
\alias{removeGaps}
\title{Remove or replace gaps from protein sequences.}
\usage{
removeGaps(x, pattern = "-", replacement = "", ...)
}
\arguments{
\item{x}{character vector, containing the input protein sequence(s).}

\item{pattern}{character string contains the gap (or other irregular)
character to be removed or replaced. Default is \code{"-"}.
For advanced usage, see \code{\link{gsub}}.}

\item{replacement}{a replacement for matched characters.
Default is \code{""} (remove the matched character).}

\item{...}{addtional parameters for \code{\link{gsub}}.}
}
\value{
a vector of protein sequence(s) with gaps or
irregular characters removed/replaced.
}
\description{
Remove/replace gaps or any irregular characters from protein sequences,
to make them suitable for feature extraction or sequence alignment
based similarity computation.
}
\examples{
# amino acid sequences that contain gaps ("-")
aaseq <- list(
  "MHGDTPTLHEYMLDLQPETTDLYCYEQLSDSSE-EEDEIDGPAGQAEPDRAHYNIVTFCCKCDSTLRLCVQS",
  "MHGDTPTLHEYMLDLQPETTDLYCYEQLNDSSE-EEDEIDGPAGQAEPDRAHYNIVTFCCKCDSTLRLCVQS"
)

\dontrun{
#' # gaps create issues for alignment
parSeqSim(aaseq)

# remove the gaps
nogapseq <- removeGaps(aaseq)
parSeqSim(nogapseq)}
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
