% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/328.Sum_Leng_GENERAL_SIM.R
\name{lengthGEN}
\alias{lengthGEN}
\title{Calculates the sum of lengths for a specific LL and UL}
\usage{
lengthGEN(n, LL, UL, hp)
}
\arguments{
\item{n}{- Number of trials}

\item{LL}{- Lower limit}

\item{UL}{- Upper limit}

\item{hp}{- Hypothetical "p"}
}
\value{
A dataframe with
 \item{sumLen}{  The sum of the expected length}
 \item{explMean}{  The mean of the expected length}
 \item{explSD}{  The Standard Deviation of the expected length}
 \item{explMax}{  The max of the expected length}
 \item{explLL}{  The Lower limit of the expected length calculated using mean - SD}
 \item{explUL}{  The Upper limit of the expected length calculated using mean + SD}
}
\description{
Calculates the sum of lengths for a specific LL and UL
}
\details{
Evaluation of intervals obtained from any method using sum
of the lengths for the \eqn{n + 1} intervals
}
\examples{
n= 5;
LL=c(0,0.01,0.0734,0.18237,0.3344,0.5492)		#Lower and Upper Limits
UL=c(0.4507,0.6655,0.8176,0.9265,0.9899,1)
hp=seq(0,1,by=0.01)
lengthGEN(n,LL,UL,hp)
}
\seealso{
Other Expected length: \code{\link{PlotexplGEN}},
  \code{\link{PlotexplSIM}}, \code{\link{PlotlengthGEN}},
  \code{\link{PlotlengthSIM}}, \code{\link{lengthSIM}}
}
