% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/212.CoverageProb_ADJ_All.R
\name{covpAWD}
\alias{covpAWD}
\title{Coverage Probability of Adjusted Wald method for given n}
\usage{
covpAWD(n, alp, h, a, b, t1, t2)
}
\arguments{
\item{n}{- Number of trials}

\item{alp}{- Alpha value (significance level required)}

\item{h}{- Adding factor}

\item{a}{- Beta parameters for hypo "p"}

\item{b}{- Beta parameters for hypo "p"}

\item{t1}{- Lower tolerance limit to check the spread of coverage Probability}

\item{t2}{- Upper tolerance limit to check the spread of coverage Probability}
}
\value{
A dataframe with
 \item{mcpAW}{  Adjusted Wald Coverage Probability}
 \item{micpAW }{   Adjusted Wald minimum coverage probability}
 \item{RMSE_N }{   Root Mean Square Error from nominal size}
 \item{RMSE_M }{   Root Mean Square Error for Coverage Probability}
 \item{RMSE_MI }{  Root Mean Square Error for minimum coverage probability}
 \item{tol }{   Required tolerance for coverage probability}
}
\description{
Coverage Probability of Adjusted Wald method for given n
}
\details{
Evaluation of adjusted Wald-type interval using coverage probability,
root mean square statistic, and the proportion of proportion lies within the
desired level of coverage
}
\examples{
n= 10; alp=0.05; h=2;a=1;b=1; t1=0.93;t2=0.97
covpAWD(n,alp,h,a,b,t1,t2)
}
\references{
[1] 1998 Agresti A and Coull BA.
Approximate is better than "Exact" for interval estimation of binomial proportions.
The American Statistician: 52; 119 - 126.

[2] 1998 Newcombe RG.
Two-sided confidence intervals for the single proportion: Comparison of seven methods.
Statistics in Medicine: 17; 857 - 872.

[3] 2008 Pires, A.M., Amado, C.
Interval Estimators for a Binomial Proportion: Comparison of Twenty Methods.
REVSTAT - Statistical Journal, 6, 165-197.
}
\seealso{
Other Coverage probability of adjusted methods: \code{\link{PlotcovpAAS}},
  \code{\link{PlotcovpAAll}}, \code{\link{PlotcovpALR}},
  \code{\link{PlotcovpALT}}, \code{\link{PlotcovpASC}},
  \code{\link{PlotcovpATW}}, \code{\link{PlotcovpAWD}},
  \code{\link{covpAAS}}, \code{\link{covpAAll}},
  \code{\link{covpALR}}, \code{\link{covpALT}},
  \code{\link{covpASC}}, \code{\link{covpATW}}
}

