% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{plot.vsel}
\alias{plot.vsel}
\title{Plot predictive performance}
\usage{
\method{plot}{vsel}(
  x,
  nterms_max = NULL,
  stats = "elpd",
  deltas = FALSE,
  alpha = 2 * pnorm(-1),
  baseline = if (!inherits(x$refmodel, "datafit")) "ref" else "best",
  thres_elpd = NA,
  resp_oscale = TRUE,
  point_size = 3,
  bar_thickness = 1,
  ranking_nterms_max = NULL,
  ranking_abbreviate = FALSE,
  ranking_abbreviate_args = list(),
  ranking_repel = NULL,
  ranking_repel_args = list(),
  ranking_colored = FALSE,
  cumulate = FALSE,
  text_angle = NULL,
  ...
)
}
\arguments{
\item{x}{An object of class \code{vsel} (returned by \code{\link[=varsel]{varsel()}} or \code{\link[=cv_varsel]{cv_varsel()}}).}

\item{nterms_max}{Maximum submodel size (number of predictor terms) for which
the performance statistics are calculated. Using \code{NULL} is effectively the
same as \code{length(ranking(object)[["fulldata"]])}. Note that \code{nterms_max}
does not count the intercept, so use \code{nterms_max = 0} for the
intercept-only model. For \code{\link[=plot.vsel]{plot.vsel()}}, \code{nterms_max} must be at least \code{1}.}

\item{stats}{One or more character strings determining which performance
statistics (i.e., utilities or losses) to estimate based on the
observations in the evaluation (or "test") set (in case of
cross-validation, these are all observations because they are partitioned
into multiple test sets; in case of \code{\link[=varsel]{varsel()}} with \code{d_test = NULL}, these
are again all observations because the test set is the same as the training
set). Available statistics are:
\itemize{
\item \code{"elpd"}: expected log (pointwise) predictive density (for a new
dataset). Estimated by the sum of the observation-specific log predictive
density values (with each of these predictive density values being
a---possibly weighted---average across the parameter draws).
\item \code{"mlpd"}: mean log predictive density, that is, \code{"elpd"} divided by the
number of observations.
\item \code{"mse"}: mean squared error (only available in the situations mentioned
in section "Details" below).
\item \code{"rmse"}: root mean squared error (only available in the situations
mentioned in section "Details" below). For the corresponding standard error
and lower and upper confidence interval bounds, bootstrapping is used.
\item \code{"acc"} (or its alias, \code{"pctcorr"}): classification accuracy (only
available in the situations mentioned in section "Details" below).
\item \code{"auc"}: area under the ROC curve (only available in the situations
mentioned in section "Details" below). For the corresponding standard error
and lower and upper confidence interval bounds, bootstrapping is used.
}}

\item{deltas}{If \code{TRUE}, the submodel statistics are estimated as differences
from the baseline model (see argument \code{baseline}). With a "difference
\emph{from} the baseline model", we mean to take the submodel statistic minus
the baseline model statistic (not the other way round).}

\item{alpha}{A number determining the (nominal) coverage \code{1 - alpha} of the
normal-approximation (or bootstrap; see argument \code{stats}) confidence
intervals. For example, in case of the normal approximation, \code{alpha = 2 * pnorm(-1)} corresponds to a confidence interval stretching by one standard
error on either side of the point estimate.}

\item{baseline}{For \code{\link[=summary.vsel]{summary.vsel()}}: Only relevant if \code{deltas} is \code{TRUE}.
For \code{\link[=plot.vsel]{plot.vsel()}}: Always relevant. Either \code{"ref"} or \code{"best"}, indicating
whether the baseline is the reference model or the best submodel found (in
terms of \code{stats[1]}), respectively.}

\item{thres_elpd}{Only relevant if \code{any(stats \%in\% c("elpd", "mlpd"))}. The
threshold for the ELPD difference (taking the submodel's ELPD minus the
baseline model's ELPD) above which the submodel's ELPD is considered to be
close enough to the baseline model's ELPD. An equivalent rule is applied in
case of the MLPD. See \code{\link[=suggest_size]{suggest_size()}} for a formalization. Supplying \code{NA}
deactivates this.}

\item{resp_oscale}{Only relevant for the latent projection. A single logical
value indicating whether to calculate the performance statistics on the
original response scale (\code{TRUE}) or on latent scale (\code{FALSE}).}

\item{point_size}{Passed to argument \code{size} of \code{\link[ggplot2:geom_point]{ggplot2::geom_point()}} and
controls the size of the points.}

\item{bar_thickness}{Passed to argument \code{linewidth} of
\code{\link[ggplot2:geom_linerange]{ggplot2::geom_linerange()}} and controls the thickness of the uncertainty
bars.}

\item{ranking_nterms_max}{Maximum submodel size (number of predictor terms)
for which the predictor names and the corresponding ranking proportions are
added on the x-axis. Using \code{NULL} is effectively the same as using
\code{nterms_max}. Using \code{NA} causes the predictor names and the corresponding
ranking proportions to be omitted. Note that \code{ranking_nterms_max} does not
count the intercept, so \code{ranking_nterms_max = 1} corresponds to the
submodel consisting of the first (non-intercept) predictor term.}

\item{ranking_abbreviate}{A single logical value indicating whether the
predictor names in the full-data predictor ranking should be abbreviated by
\code{\link[=abbreviate]{abbreviate()}} (\code{TRUE}) or not (\code{FALSE}). See also argument
\code{ranking_abbreviate_args} and section "Value".}

\item{ranking_abbreviate_args}{A \code{list} of arguments (except for \code{names.arg})
to be passed to \code{\link[=abbreviate]{abbreviate()}} in case of \code{ranking_abbreviate = TRUE}.}

\item{ranking_repel}{Either \code{NULL}, \code{"text"}, or \code{"label"}. By \code{NULL}, the
full-data predictor ranking and the corresponding ranking proportions are
placed below the x-axis. By \code{"text"} or \code{"label"}, they are placed within
the plotting area, using \code{\link[ggrepel:geom_text_repel]{ggrepel::geom_text_repel()}} or
\code{\link[ggrepel:geom_text_repel]{ggrepel::geom_label_repel()}}, respectively. See also argument
\code{ranking_repel_args}.}

\item{ranking_repel_args}{A \code{list} of arguments (except for \code{mapping}) to be
passed to \code{\link[ggrepel:geom_text_repel]{ggrepel::geom_text_repel()}} or \code{\link[ggrepel:geom_text_repel]{ggrepel::geom_label_repel()}} in
case of \code{ranking_repel = "text"} or \code{ranking_repel = "label"},
respectively.}

\item{ranking_colored}{A single logical value indicating whether the points
and the uncertainty bars should be gradient-colored according to the CV
ranking proportions (\code{TRUE}) or not (\code{FALSE}). The CV ranking proportions
may be cumulated (see argument \code{cumulate}). Note that the point and the
uncertainty bar at submodel size 0 (i.e., at the intercept-only model) are
always colored in gray because the intercept is forced to be selected
before any predictors are selected (in other words, the reason is that for
submodel size 0, the question of variability across CV folds is not
appropriate in the first place).}

\item{cumulate}{Passed to argument \code{cumulate} of \code{\link[=cv_proportions]{cv_proportions()}}. Affects
the ranking proportions given on the x-axis (below the full-data predictor
ranking).}

\item{text_angle}{Passed to argument \code{angle} of \code{\link[ggplot2:element]{ggplot2::element_text()}} for
the x-axis tick labels. In case of long predictor names (and/or large
\code{nterms_max}), \code{text_angle = 45} might be helpful (for example).}

\item{...}{Arguments passed to the internal function which is used for
bootstrapping (if applicable; see argument \code{stats}). Currently, relevant
arguments are \code{B} (the number of bootstrap samples, defaulting to \code{2000})
and \code{seed} (see \code{\link[=set.seed]{set.seed()}}, but defaulting to \code{NA} so that \code{\link[=set.seed]{set.seed()}}
is not called within that function at all).}
}
\value{
A \pkg{ggplot2} plotting object (of class \code{gg} and \code{ggplot}). If
\code{ranking_abbreviate} is \code{TRUE}, the output of \code{\link[=abbreviate]{abbreviate()}} is stored in
an attribute called \code{projpred_ranking_abbreviated} (to allow the
abbreviations to be easily mapped back to the original predictor names).
}
\description{
This is the \code{\link[=plot]{plot()}} method for \code{vsel} objects (returned by \code{\link[=varsel]{varsel()}} or
\code{\link[=cv_varsel]{cv_varsel()}}). It visualizes the predictive performance of the reference
model (possibly also that of some other "baseline" model) and that of the
submodels along the full-data predictor ranking. Basic information about the
(CV) variability in the ranking of the predictors is included as well (if
available; inferred from \code{\link[=cv_proportions]{cv_proportions()}}). For a tabular representation,
see \code{\link[=summary.vsel]{summary.vsel()}}.
}
\details{
The \code{stats} options \code{"mse"} and \code{"rmse"} are only available for:
\itemize{
\item the traditional projection,
\item the latent projection with \code{resp_oscale = FALSE},
\item the latent projection with \code{resp_oscale = TRUE} in combination with
\verb{<refmodel>$family$cats} being \code{NULL}.
}

The \code{stats} option \code{"acc"} (= \code{"pctcorr"}) is only available for:
\itemize{
\item the \code{\link[=binomial]{binomial()}} family in case of the traditional projection,
\item all families in case of the augmented-data projection,
\item the \code{\link[=binomial]{binomial()}} family (on the original response scale) in case of the
latent projection with \code{resp_oscale = TRUE} in combination with
\verb{<refmodel>$family$cats} being \code{NULL},
\item all families (on the original response scale) in case of the latent
projection with \code{resp_oscale = TRUE} in combination with
\verb{<refmodel>$family$cats} being not \code{NULL}.
}

The \code{stats} option \code{"auc"} is only available for:
\itemize{
\item the \code{\link[=binomial]{binomial()}} family in case of the traditional projection,
\item the \code{\link[=binomial]{binomial()}} family (on the original response scale) in case of the
latent projection with \code{resp_oscale = TRUE} in combination with
\verb{<refmodel>$family$cats} being \code{NULL}.
}
}
\section{Horizontal lines}{
As long as the reference model's performance is computable, it is always
shown in the plot as a dashed red horizontal line. If \code{baseline = "best"},
the baseline model's performance is shown as a dotted black horizontal line.
If \code{!is.na(thres_elpd)} and \code{any(stats \%in\% c("elpd", "mlpd"))}, the value
supplied to \code{thres_elpd} (which is automatically adapted internally in case
of the MLPD or \code{deltas = FALSE}) is shown as a dot-dashed gray horizontal
line for the reference model and, if \code{baseline = "best"}, as a long-dashed
green horizontal line for the baseline model.
}

\examples{
\dontshow{if (requireNamespace("rstanarm", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Data:
dat_gauss <- data.frame(y = df_gaussian$y, df_gaussian$x)

# The "stanreg" fit which will be used as the reference model (with small
# values for `chains` and `iter`, but only for technical reasons in this
# example; this is not recommended in general):
fit <- rstanarm::stan_glm(
  y ~ X1 + X2 + X3 + X4 + X5, family = gaussian(), data = dat_gauss,
  QR = TRUE, chains = 2, iter = 500, refresh = 0, seed = 9876
)

# Run varsel() (here without cross-validation, with L1 search, and with small
# values for `nterms_max` and `nclusters_pred`, but only for the sake of
# speed in this example; this is not recommended in general):
vs <- varsel(fit, method = "L1", nterms_max = 3, nclusters_pred = 10,
             seed = 5555)
print(plot(vs))
\dontshow{\}) # examplesIf}
}
